/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

@RequiresPersistentGraphDatabase(value=false)
public abstract class AbstractNeo4jTestCase {
    protected static final File NEO4J_BASE_DIR = new File("target", "var");
    @ClassRule
    public static final TestRule START_GRAPHDB = (base, description) -> {
        AbstractNeo4jTestCase.tearDownDb();
        AbstractNeo4jTestCase.setupGraphDatabase(description.getTestClass().getName(), description.getTestClass().getAnnotation(RequiresPersistentGraphDatabase.class).value());
        return base;
    };
    private static ThreadLocal<GraphDatabaseAPI> threadLocalGraphDb = new ThreadLocal();
    private static ThreadLocal<String> currentTestClassName = new ThreadLocal();
    private static ThreadLocal<Boolean> requiresPersistentGraphDatabase = new ThreadLocal();
    private GraphDatabaseAPI graphDb = threadLocalGraphDb.get();
    private Transaction tx;

    protected AbstractNeo4jTestCase() {
    }

    public GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    private static void setupGraphDatabase(String testClassName, boolean requiresPersistentGraphDatabase) {
        AbstractNeo4jTestCase.requiresPersistentGraphDatabase.set(requiresPersistentGraphDatabase);
        currentTestClassName.set(testClassName);
        if (requiresPersistentGraphDatabase) {
            try {
                FileUtils.deleteRecursively((File)AbstractNeo4jTestCase.getStorePath("neo-test"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        threadLocalGraphDb.set((GraphDatabaseAPI)(requiresPersistentGraphDatabase ? new TestGraphDatabaseFactory().newEmbeddedDatabase(AbstractNeo4jTestCase.getStorePath("neo-test")) : new TestGraphDatabaseFactory().newImpermanentDatabase()));
    }

    public GraphDatabaseAPI getGraphDbAPI() {
        return this.graphDb;
    }

    protected boolean restartGraphDbBetweenTests() {
        return false;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public static File getStorePath(String endPath) {
        return new File(NEO4J_BASE_DIR, currentTestClassName.get() + "-" + endPath).getAbsoluteFile();
    }

    @Before
    public void setUpTest() {
        if (this.restartGraphDbBetweenTests() && this.graphDb == null) {
            AbstractNeo4jTestCase.setupGraphDatabase(currentTestClassName.get(), requiresPersistentGraphDatabase.get());
            this.graphDb = threadLocalGraphDb.get();
        }
        this.tx = this.graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (this.tx != null) {
            this.tx.close();
        }
        if (this.restartGraphDbBetweenTests()) {
            AbstractNeo4jTestCase.tearDownDb();
        }
    }

    @AfterClass
    public static void tearDownDb() {
        try {
            if (threadLocalGraphDb.get() != null) {
                threadLocalGraphDb.get().shutdown();
            }
        }
        finally {
            threadLocalGraphDb.remove();
        }
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public Transaction newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.close();
        }
        this.tx = this.graphDb.beginTx();
        return this.tx;
    }

    public void commit() {
        if (this.tx != null) {
            try {
                this.tx.success();
                this.tx.close();
            }
            finally {
                this.tx = null;
            }
        }
    }

    public void finish() {
        if (this.tx != null) {
            try {
                this.tx.close();
            }
            finally {
                this.tx = null;
            }
        }
    }

    public void rollback() {
        if (this.tx != null) {
            try {
                this.tx.failure();
                this.tx.close();
            }
            finally {
                this.tx = null;
            }
        }
    }

    public NodeManager getNodeManager() {
        return (NodeManager)this.graphDb.getDependencyResolver().resolveDependency(NodeManager.class);
    }

    public IdGenerator getIdGenerator(IdType idType) {
        return ((IdGeneratorFactory)this.graphDb.getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(idType);
    }

    public static void deleteFileOrDirectory(String dir) {
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(dir));
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractNeo4jTestCase.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    protected long propertyRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore());
    }

    public static <RECORD extends AbstractBaseRecord> int numberOfRecordsInUse(RecordStore<RECORD> store) {
        int inUse = 0;
        for (long id = (long)store.getNumberOfReservedLowIds(); id < store.getHighId(); ++id) {
            AbstractBaseRecord record = store.getRecord(id, store.newRecord(), RecordLoad.FORCE);
            if (!record.inUse()) continue;
            ++inUse;
        }
        return inUse;
    }

    protected long dynamicStringRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getStringStore());
    }

    protected long dynamicArrayRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getArrayStore());
    }

    protected PropertyStore propertyStore() {
        return ((RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getPropertyStore();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface RequiresPersistentGraphDatabase {
        public boolean value() default true;
    }
}

