/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DataStatementArgumentVerificationTest {
    @Test
    public void shouldReturnNoPropertyFromNodeGetPropertyWithoutDelegatingForNoSuchPropertyKeyIdConstant() throws Exception {
        OperationsFacade statement = this.stubStatement();
        Value value = statement.nodeGetProperty(17L, -1);
        Assert.assertTrue((String)"should return NoProperty", (value == Values.NO_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void shouldReturnNoPropertyFromRelationshipGetPropertyWithoutDelegatingForNoSuchPropertyKeyIdConstant() throws Exception {
        OperationsFacade statement = this.stubStatement();
        Value value = statement.relationshipGetProperty(17L, -1);
        Assert.assertEquals((String)"should return NoProperty", (Object)value, (Object)Values.NO_VALUE);
    }

    @Test
    public void shouldReturnNoPropertyFromGraphGetPropertyWithoutDelegatingForNoSuchPropertyKeyIdConstant() throws Exception {
        OperationsFacade statement = this.stubStatement();
        Value value = statement.graphGetProperty(-1);
        Assert.assertEquals((String)"should return NoProperty", (Object)value, (Object)Values.NO_VALUE);
    }

    @Test
    public void shouldReturnEmptyIdIteratorFromNodesGetForLabelForNoSuchLabelConstant() throws Exception {
        OperationsFacade statement = this.stubStatement();
        PrimitiveLongIterator nodes = statement.nodesGetForLabel(-1);
        Assert.assertFalse((String)"should not contain any ids", (boolean)nodes.hasNext());
    }

    @Test
    public void shouldAlwaysReturnFalseFromNodeHasLabelForNoSuchLabelConstant() throws Exception {
        OperationsFacade statement = this.stubStatement();
        boolean hasLabel = statement.nodeHasLabel(17L, -1);
        Assert.assertFalse((String)"should not contain any ids", (boolean)hasLabel);
    }

    private OperationsFacade stubStatement() {
        return new OperationsFacade((KernelTransaction)Mockito.mock(KernelTransaction.class), (KernelStatement)Mockito.mock(KernelStatement.class), new Procedures(), (StatementOperationParts)Mockito.mock(StatementOperationParts.class));
    }
}

