/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class DatabaseSchemaStateTest {
    private DatabaseSchemaState stateStore;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void should_apply_updates_correctly() {
        this.stateStore.apply(MapUtil.stringMap((String[])new String[]{"key", "created_value"}));
        String result = (String)this.stateStore.get((Object)"key");
        Assert.assertEquals((Object)"created_value", (Object)result);
    }

    @Test
    public void should_flush() {
        this.stateStore.apply(MapUtil.stringMap((String[])new String[]{"key", "created_value"}));
        this.stateStore.clear();
        String result = (String)this.stateStore.get((Object)"key");
        Assert.assertEquals(null, (Object)result);
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(DatabaseSchemaState.class).debug("Schema state store has been cleared.")});
    }

    @Before
    public void before() {
        this.stateStore = new DatabaseSchemaState((LogProvider)this.logProvider);
    }
}

