/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.DefaultTransactionTracer;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class DefaultTransactionTracerTest {
    private final FakeClock clock = Clocks.fakeClock();
    private final OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
    private final DefaultTransactionTracer.Monitor monitor = (DefaultTransactionTracer.Monitor)Mockito.mock(DefaultTransactionTracer.Monitor.class);

    @Test
    public void shouldComputeStartEndAndTotalTimeForLogRotation() throws Throwable {
        DefaultTransactionTracer tracer = new DefaultTransactionTracer((SystemNanoClock)this.clock, this.monitor, (JobScheduler)this.jobScheduler);
        this.triggerEvent(tracer, 20);
        Assert.assertEquals((long)1L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)20L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
        ((DefaultTransactionTracer.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).lastLogRotationEventDuration(20L);
        this.triggerEvent(tracer, 30);
        Assert.assertEquals((long)2L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)50L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
        ((DefaultTransactionTracer.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).lastLogRotationEventDuration(30L);
    }

    @Test
    public void shouldReturnMinusOneIfNoDataIsAvailableForLogRotation() throws Throwable {
        DefaultTransactionTracer tracer = new DefaultTransactionTracer((SystemNanoClock)this.clock, this.monitor, (JobScheduler)this.jobScheduler);
        this.jobScheduler.runJob();
        Assert.assertEquals((long)0L, (long)tracer.numberOfLogRotationEvents());
        Assert.assertEquals((long)0L, (long)tracer.logRotationAccumulatedTotalTimeMillis());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.monitor});
    }

    private void triggerEvent(DefaultTransactionTracer tracer, int eventDuration) {
        try (TransactionEvent txEvent = tracer.beginTransaction();
             CommitEvent commitEvent = txEvent.beginCommitEvent();
             LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();){
            this.clock.forward(ThreadLocalRandom.current().nextLong(200L), TimeUnit.MILLISECONDS);
            try (LogRotateEvent event = logAppendEvent.beginLogRotate();){
                this.clock.forward((long)eventDuration, TimeUnit.MILLISECONDS);
            }
        }
        this.jobScheduler.runJob();
    }
}

