/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.time.Clocks;
import org.neo4j.values.virtual.VirtualValues;

public class ExecutingQueryListTest {
    @Test
    public void removingTheLastQueryReturnsAnEmptyList() {
        ExecutingQuery aQuery = this.createExecutingQuery(1, "query");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(aQuery);
        ExecutingQueryList result = list.remove(aQuery);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)ExecutingQueryList.EMPTY));
    }

    @Test
    public void shouldNotChangeAListWhenRemovingAQueryThatIsNotInTheList() throws Exception {
        ExecutingQuery query1 = this.createExecutingQuery(1, "query1");
        ExecutingQuery query2 = this.createExecutingQuery(2, "query2");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(query1);
        ExecutingQueryList result = list.remove(query2);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void addingQueriesKeepsInsertOrder() {
        ExecutingQuery query1 = this.createExecutingQuery(1, "query1");
        ExecutingQuery query2 = this.createExecutingQuery(2, "query2");
        ExecutingQuery query3 = this.createExecutingQuery(3, "query3");
        ExecutingQuery query4 = this.createExecutingQuery(4, "query4");
        ExecutingQuery query5 = this.createExecutingQuery(5, "query5");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(query1).push(query2).push(query3).push(query4).push(query5);
        List result = list.queries().collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList(query5, query4, query3, query2, query1)));
    }

    @Test
    public void removingQueryInTheMiddleKeepsOrder() {
        ExecutingQuery query1 = this.createExecutingQuery(1, "query1");
        ExecutingQuery query2 = this.createExecutingQuery(2, "query2");
        ExecutingQuery query3 = this.createExecutingQuery(3, "query3");
        ExecutingQuery query4 = this.createExecutingQuery(4, "query4");
        ExecutingQuery query5 = this.createExecutingQuery(5, "query5");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(query1).push(query2).push(query3).push(query4).push(query5);
        List result = list.remove(query3).queries().collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList(query5, query4, query2, query1)));
    }

    private ExecutingQuery createExecutingQuery(int queryId, String query) {
        return new ExecutingQuery((long)queryId, ClientConnectionInfo.EMBEDDED_CONNECTION, "me", query, VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> 0L, (PageCursorCounters)PageCursorTracer.NULL, Thread.currentThread().getId(), Thread.currentThread().getName(), Clocks.nanoClock(), CpuClock.CPU_CLOCK, HeapAllocation.HEAP_ALLOCATION);
    }
}

