/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.api.IndexSimpleValueValidator;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.Values;

public class IndexSimpleValueValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void nullIsNotAllowed() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        this.getValidator().validate(null);
    }

    @Test
    public void tooLongStringIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property value bytes length: 35000 is longer then 32766, which is maximum supported length of indexed property value.");
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)35000));
    }

    @Test
    public void stringOverExceedLimitNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property value bytes length: 32767 is longer then 32766, which is maximum supported length of indexed property value.");
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)Short.MAX_VALUE));
    }

    @Test
    public void numberIsValidValue() {
        this.getValidator().validate((Object)5);
        this.getValidator().validate((Object)5.0);
        this.getValidator().validate((Object)Float.valueOf(5.0f));
        this.getValidator().validate((Object)5L);
    }

    @Test
    public void shortStringIsValidValue() {
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)5));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)10));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)250));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)450));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)32766));
    }

    protected Validator<Object> getValidator() {
        return object -> IndexSimpleValueValidator.INSTANCE.validate(Values.of((Object)object));
    }
}

