/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;

public class KernelStatementTest {
    @Test(expected=TransactionTerminatedException.class)
    public void shouldThrowTerminateExceptionWhenTransactionTerminated() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.getReasonIfTerminated()).thenReturn(Optional.of(Status.Transaction.Terminated));
        Mockito.when((Object)transaction.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        KernelStatement statement = new KernelStatement(transaction, null, (StorageStatement)Mockito.mock(StorageStatement.class), null, (AccessCapability)new CanWrite(), LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), EmptyVersionContextSupplier.EMPTY);
        statement.acquire();
        statement.readOperations().nodeExists(0L);
    }

    @Test
    public void shouldReleaseStorageStatementWhenForceClosed() throws Exception {
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = new KernelStatement((KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class), null, storeStatement, new Procedures(), (AccessCapability)new CanWrite(), LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), EmptyVersionContextSupplier.EMPTY);
        statement.acquire();
        try {
            statement.forceClose();
        }
        catch (KernelStatement.StatementNotClosedException statementNotClosedException) {
            // empty catch block
        }
        ((StorageStatement)Mockito.verify((Object)storeStatement)).release();
    }

    @Test(expected=NotInTransactionException.class)
    public void assertStatementIsNotOpenWhileAcquireIsNotInvoked() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        TxStateHolder txStateHolder = (TxStateHolder)Mockito.mock(TxStateHolder.class);
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        AccessCapability accessCapability = (AccessCapability)Mockito.mock(AccessCapability.class);
        Procedures procedures = (Procedures)Mockito.mock(Procedures.class);
        KernelStatement statement = new KernelStatement(transaction, txStateHolder, storeStatement, procedures, accessCapability, LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), EmptyVersionContextSupplier.EMPTY);
        statement.assertOpen();
    }
}

