/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.test.DoubleLatch;

@RunWith(value=Parameterized.class)
public class KernelTransactionImplementationTest
extends KernelTransactionTestBase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter
    public Consumer<KernelTransaction> transactionInitializer;
    @Parameterized.Parameter(value=1)
    public boolean isWriteTx;
    @Parameterized.Parameter(value=2)
    public String ignored;

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> parameters() {
        Consumer<KernelTransaction> readTxInitializer = tx -> {};
        Consumer<KernelTransaction> writeTxInitializer = tx -> {
            try (KernelStatement statement = (KernelStatement)tx.acquireStatement();){
                statement.txState().nodeDoCreate(42L);
            }
        };
        return Arrays.asList({readTxInitializer, false, "read"}, {writeTxInitializer, true, "write"});
    }

    @Test
    public void shouldCommitSuccessfulTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.success();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackUnsuccessfulTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackFailedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.failure();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackAndThrowOnFailedAndSuccess() throws Exception {
        boolean exceptionReceived = false;
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.failure();
            transaction.success();
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingTerminatedTransaction() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.markForTermination((Status)Status.General.UnknownError);
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingSuccessfulButTerminatedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            Assert.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingTerminatedButSuccessfulTransaction() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.success();
        Assert.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldNotDowngradeFailureState() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            transaction.failure();
            Assert.assertEquals((Object)Status.General.UnknownError, transaction.getReasonIfTerminated().get());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldIgnoreTerminateAfterCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.close();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldIgnoreTerminateAfterRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.close();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test(expected=TransactionTerminatedException.class)
    public void shouldThrowOnTerminationInCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.close();
    }

    @Test
    public void shouldIgnoreTerminationDuringRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.close();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldAllowTerminatingFromADifferentThread() throws Exception {
        DoubleLatch latch = new DoubleLatch(1);
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        Future<?> terminationFuture = Executors.newSingleThreadExecutor().submit(() -> KernelTransactionImplementationTest.lambda$shouldAllowTerminatingFromADifferentThread$2(latch, (KernelTransaction)transaction));
        transaction.success();
        latch.startAndWaitForAllToStartAndFinish();
        Assert.assertNull(terminationFuture.get(1L, TimeUnit.MINUTES));
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldUseStartTimeAndTxIdFromWhenStartingTxAsHeader() throws Exception {
        long startingTime = this.clock.millis();
        Mockito.when((Object)this.explicitIndexState.hasChanges()).thenReturn((Object)true);
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            Collection commands = (Collection)invocation.getArgumentAt(0, Collection.class);
            commands.add(Mockito.mock(Command.class));
            return null;
        }).when((Object)this.storageEngine)).createCommands((Collection)Matchers.any(Collection.class), (ReadableTransactionState)Matchers.any(TransactionState.class), (StorageStatement)Matchers.any(StorageStatement.class), (ResourceLocker)Matchers.any(ResourceLocker.class), Matchers.anyLong());
        try (KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());){
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
            transaction.initialize(5L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, 0L);
            try (KernelStatement statement = transaction.acquireStatement();){
                statement.explicitIndexTxState();
            }
            this.clock.forward(5L, TimeUnit.MILLISECONDS);
            Mockito.when((Object)this.metaDataStore.getLastCommittedTransactionId()).thenReturn((Object)7L);
            transaction.success();
        }
        Assert.assertEquals((long)5L, (long)this.commitProcess.transaction.getLatestCommittedTxWhenStarted());
        Assert.assertEquals((long)startingTime, (long)this.commitProcess.transaction.getTimeStarted());
        Assert.assertEquals((long)(startingTime + 5L), (long)this.commitProcess.transaction.getTimeCommitted());
    }

    @Test
    public void successfulTxShouldNotifyKernelTransactionsThatItIsClosed() throws TransactionFailureException {
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.success();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    @Test
    public void failedTxShouldNotifyKernelTransactionsThatItIsClosed() throws TransactionFailureException {
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.failure();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    private void verifyExtraInteractionWithTheMonitor(TransactionMonitor transactionMonitor, boolean isWriteTx) {
        if (isWriteTx) {
            ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).upgradeToWriteTransaction();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{transactionMonitor});
    }

    @Test
    public void shouldIncrementReuseCounterOnReuse() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.securityContext());
        int reuseCount = transaction.getReuseCount();
        transaction.close();
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(1L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.securityContext(), 0L);
        Assert.assertEquals((long)(reuseCount + 1), (long)transaction.getReuseCount());
    }

    @Test
    public void markForTerminationNotInitializedTransaction() {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        tx.markForTermination((Status)Status.General.UnknownError);
        Assert.assertEquals((Object)Status.General.UnknownError, tx.getReasonIfTerminated().get());
    }

    @Test
    public void markForTerminationInitializedTransaction() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        tx.markForTermination((Status)Status.General.UnknownError);
        Assert.assertEquals((Object)Status.General.UnknownError, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @Test
    public void markForTerminationTerminatedTransaction() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.markForTermination((Status)Status.Transaction.Outdated);
        tx.markForTermination((Status)Status.Transaction.LockClientStopped);
        Assert.assertEquals((Object)Status.Transaction.Terminated, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedNeitherSuccessNorFailureClosesWithoutThrowing() throws TransactionFailureException {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedForSuccessThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.markForTermination((Status)Status.General.UnknownError);
        try {
            tx.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void terminatedTxMarkedForFailureClosesWithoutThrowing() throws TransactionFailureException {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedForBothSuccessAndFailureThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        try {
            tx.close();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void txMarkedForBothSuccessAndFailureThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext(), locksClient);
        tx.success();
        tx.failure();
        try {
            tx.close();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    @Test
    public void initializedTransactionShouldHaveNoTerminationReason() throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        Assert.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
    }

    @Test
    public void shouldReportCorrectTerminationReason() throws Exception {
        Status.Transaction status = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.markForTermination((Status)status);
        Assert.assertSame((Object)status, tx.getReasonIfTerminated().get());
    }

    @Test
    public void closedTransactionShouldHaveNoTerminationReason() throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.close();
        Assert.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
    }

    @Test
    public void shouldCallCloseListenerOnCloseWhenCommitting() throws Exception {
        AtomicLong closeTxId = new AtomicLong(Long.MIN_VALUE);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.registerCloseListener(closeTxId::set);
        if (this.isWriteTx) {
            tx.upgradeToDataWrites();
            tx.txState().nodeDoCreate(42L);
        }
        tx.success();
        tx.close();
        Assert.assertThat((Object)closeTxId.get(), (Matcher)(this.isWriteTx ? org.hamcrest.Matchers.greaterThan((Comparable)Long.valueOf(1L)) : org.hamcrest.Matchers.equalTo((Object)0L)));
    }

    @Test
    public void shouldCallCloseListenerOnCloseWhenRollingBack() throws Exception {
        AtomicLong closeTxId = new AtomicLong(Long.MIN_VALUE);
        KernelTransactionImplementation tx = this.newTransaction(this.securityContext());
        tx.registerCloseListener(closeTxId::set);
        tx.failure();
        tx.close();
        Assert.assertEquals((long)-1L, (long)closeTxId.get());
    }

    @Test
    public void transactionWithCustomTimeout() {
        long transactionTimeout = 5L;
        KernelTransactionImplementation transaction = this.newTransaction(transactionTimeout);
        Assert.assertEquals((String)"Transaction should have custom configured timeout.", (long)transactionTimeout, (long)transaction.timeout());
    }

    @Test
    public void transactionStartTime() {
        long startTime = this.clock.forward(5L, TimeUnit.MINUTES).millis();
        KernelTransactionImplementation transaction = this.newTransaction(SecurityContext.AUTH_DISABLED);
        Assert.assertEquals((String)"Transaction start time should be the same as clock time.", (long)startTime, (long)transaction.startTime());
    }

    @Test
    public void markForTerminationWithCorrectReuseCount() throws Exception {
        int reuseCount = 10;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initializeAndClose(tx, reuseCount);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.securityContext(), 0L);
        Assert.assertTrue((boolean)tx.markForTermination((long)reuseCount, (Status)terminationReason));
        Assert.assertEquals((Object)terminationReason, tx.getReasonIfTerminated().get());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @Test
    public void markForTerminationWithIncorrectReuseCount() throws Exception {
        int reuseCount = 13;
        int nextReuseCount = reuseCount + 2;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initializeAndClose(tx, reuseCount);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.securityContext(), 0L);
        Assert.assertFalse((boolean)tx.markForTermination((long)nextReuseCount, (Status)terminationReason));
        Assert.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
        ((Locks.Client)Mockito.verify((Object)locksClient, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void closeClosedTransactionIsNotAllowed() throws TransactionFailureException {
        KernelTransactionImplementation transaction = this.newTransaction(1000L);
        transaction.close();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("This transaction has already been completed.");
        transaction.close();
    }

    private SecurityContext securityContext() {
        return this.isWriteTx ? AnonymousContext.write() : AnonymousContext.read();
    }

    private void initializeAndClose(KernelTransactionImplementation tx, int times) throws Exception {
        for (int i = 0; i < times; ++i) {
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
            tx.initialize((long)(i + 10), (long)(i + 10), (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.securityContext(), 0L);
            tx.close();
        }
    }

    private static /* synthetic */ void lambda$shouldAllowTerminatingFromADifferentThread$2(DoubleLatch latch, KernelTransaction transaction) {
        latch.waitForAllToStart();
        transaction.markForTermination((Status)Status.General.UnknownError);
        latch.finish();
    }
}

