/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Race;
import org.neo4j.time.Clocks;

public class KernelTransactionTerminationTest {
    private static final int TEST_RUN_TIME_MS = 5000;

    @Test(timeout=100000L)
    public void transactionCantBeTerminatedAfterItIsClosed() throws Throwable {
        this.runTwoThreads(tx -> tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed), tx -> {
            KernelTransactionTerminationTest.close((KernelTransaction)tx);
            Assert.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
            tx.initialize();
        });
    }

    @Test(timeout=100000L)
    public void closeTransaction() throws Throwable {
        LinkedBlockingQueue committerToTerminator = new LinkedBlockingQueue(1);
        LinkedBlockingQueue terminatorToCommitter = new LinkedBlockingQueue(1);
        this.runTwoThreads(tx -> {
            Boolean terminatorShouldAct = (Boolean)committerToTerminator.poll();
            if (terminatorShouldAct != null && terminatorShouldAct.booleanValue()) {
                TerminatorAction action = TerminatorAction.random();
                action.executeOn((KernelTransaction)tx);
                Assert.assertTrue((boolean)terminatorToCommitter.add(action));
            }
        }, tx -> {
            tx.initialize();
            CommitterAction committerAction = CommitterAction.random();
            committerAction.executeOn((KernelTransaction)tx);
            if (committerToTerminator.offer(true)) {
                TerminatorAction terminatorAction;
                try {
                    terminatorAction = (TerminatorAction)((Object)((Object)terminatorToCommitter.poll(1L, TimeUnit.SECONDS)));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (terminatorAction != null) {
                    KernelTransactionTerminationTest.close(tx, committerAction, terminatorAction);
                }
            }
        });
    }

    private void runTwoThreads(Consumer<TestKernelTransaction> thread1Action, Consumer<TestKernelTransaction> thread2Action) throws Throwable {
        TestKernelTransaction tx = TestKernelTransaction.create().initialize();
        AtomicLong t1Count = new AtomicLong();
        AtomicLong t2Count = new AtomicLong();
        long endTime = System.currentTimeMillis() + 5000L;
        int limit = 20000;
        Race race = new Race();
        race.withEndCondition(new BooleanSupplier[]{() -> t1Count.get() >= (long)limit && t2Count.get() >= (long)limit || System.currentTimeMillis() >= endTime});
        race.addContestant(() -> {
            thread1Action.accept(tx);
            t1Count.incrementAndGet();
        });
        race.addContestant(() -> {
            thread2Action.accept(tx);
            t2Count.incrementAndGet();
        });
        race.go();
    }

    private static void close(KernelTransaction tx) {
        try {
            tx.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void close(TestKernelTransaction tx, CommitterAction committer, TerminatorAction terminator) {
        try {
            if (terminator == TerminatorAction.NONE) {
                committer.closeNotTerminated(tx);
            } else {
                committer.closeTerminated(tx);
            }
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CommitTrackingMonitor
    implements TransactionMonitor {
        volatile boolean committed;
        volatile boolean rolledBack;
        volatile boolean terminated;

        private CommitTrackingMonitor() {
        }

        public void transactionStarted() {
        }

        public void transactionFinished(boolean successful, boolean writeTx) {
            if (successful) {
                this.committed = true;
            } else {
                this.rolledBack = true;
            }
        }

        public void transactionTerminated(boolean writeTx) {
            this.terminated = true;
        }

        public void upgradeToWriteTransaction() {
        }

        void reset() {
            this.committed = false;
            this.rolledBack = false;
            this.terminated = false;
        }
    }

    private static class TestKernelTransaction
    extends KernelTransactionImplementation {
        final CommitTrackingMonitor monitor;

        TestKernelTransaction(CommitTrackingMonitor monitor) {
            super((StatementOperationParts)Mockito.mock(StatementOperationParts.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), new TransactionHooks(), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), new Procedures(), TransactionHeaderInformationFactory.DEFAULT, (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), (TransactionMonitor)monitor, () -> (ExplicitIndexTransactionState)Mockito.mock(ExplicitIndexTransactionState.class), (Pool)Mockito.mock(Pool.class), (Clock)Clocks.fakeClock(), TransactionTracer.NULL, LockTracer.NONE, PageCursorTracerSupplier.NULL, (StorageEngine)Mockito.mock(StorageEngine.class, (Answer)Mockito.RETURNS_MOCKS), (AccessCapability)new CanWrite(), EmptyVersionContextSupplier.EMPTY);
            this.monitor = monitor;
        }

        static TestKernelTransaction create() {
            return new TestKernelTransaction(new CommitTrackingMonitor());
        }

        TestKernelTransaction initialize() {
            this.initialize(42L, 42L, (StatementLocks)new SimpleStatementLocks((Locks.Client)new NoOpClient()), KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, 0L);
            this.monitor.reset();
            return this;
        }

        void assertCommitted() {
            Assert.assertTrue((boolean)this.monitor.committed);
        }

        void assertRolledBack() {
            Assert.assertTrue((boolean)this.monitor.rolledBack);
        }

        void assertTerminated() {
            Assert.assertEquals((Object)Status.Transaction.TransactionMarkedAsFailed, this.getReasonIfTerminated().get());
            Assert.assertTrue((boolean)this.monitor.terminated);
        }

        void assertNotTerminated() {
            Assert.assertFalse((boolean)this.getReasonIfTerminated().isPresent());
            Assert.assertFalse((boolean)this.monitor.terminated);
        }
    }

    private static enum CommitterAction {
        NONE{

            @Override
            void executeOn(KernelTransaction tx) {
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertTerminated();
                tx.close();
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.close();
                tx.assertRolledBack();
            }
        }
        ,
        MARK_SUCCESS{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.success();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) {
                tx.assertTerminated();
                try {
                    tx.close();
                    Assert.fail((String)"Exception expected");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
                }
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.close();
                tx.assertCommitted();
            }
        }
        ,
        MARK_FAILURE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.failure();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeTerminated(tx);
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeNotTerminated(tx);
            }
        }
        ,
        MARK_SUCCESS_AND_FAILURE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.success();
                tx.failure();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                MARK_SUCCESS.closeTerminated(tx);
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) {
                tx.assertNotTerminated();
                try {
                    tx.close();
                    Assert.fail((String)"Exception expected");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
                }
                tx.assertRolledBack();
            }
        };

        static final CommitterAction[] VALUES;

        abstract void executeOn(KernelTransaction var1);

        abstract void closeTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        abstract void closeNotTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        static CommitterAction random() {
            return VALUES[ThreadLocalRandom.current().nextInt(VALUES.length)];
        }

        static {
            VALUES = CommitterAction.values();
        }
    }

    private static enum TerminatorAction {
        NONE{

            @Override
            void executeOn(KernelTransaction tx) {
            }
        }
        ,
        TERMINATE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed);
            }
        };


        abstract void executeOn(KernelTransaction var1);

        static TerminatorAction random() {
            return ThreadLocalRandom.current().nextBoolean() ? TERMINATE : NONE;
        }
    }
}

