/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class KernelTransactionTimeoutMonitorIT {
    @Rule
    public DatabaseRule database = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.transaction_monitor_check_interval, "100ms");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int NODE_ID = 0;
    private ExecutorService executor;

    @Before
    public void setUp() throws Exception {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
    }

    @Test(timeout=30000L)
    public void terminateExpiredTransaction() throws Exception {
        try (Transaction transaction = this.database.beginTx();){
            this.database.createNode();
            transaction.success();
        }
        this.expectedException.expectMessage("The transaction has been terminated.");
        transaction = this.database.beginTx();
        var2_2 = null;
        try {
            Node nodeById = this.database.getNodeById(0L);
            nodeById.setProperty("a", (Object)"b");
            this.executor.submit(this.startAnotherTransaction()).get();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private Runnable startAnotherTransaction() {
        return () -> {
            try (InternalTransaction transaction = this.database.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, 1L, TimeUnit.SECONDS);){
                Node node = this.database.getNodeById(0L);
                node.setProperty("c", (Object)"d");
            }
        };
    }
}

