/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class OperationsFacadeTest {
    @Rule
    public DatabaseRule db = new ImpermanentDatabaseRule();
    private final Label LABEL1 = Label.label((String)"Label1");
    private final String PROP1 = "Prop1";
    private int labelId;
    private int propertyId;

    @Before
    public void setup() {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(this.LABEL1).setProperty("Prop1", (Object)1);
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try (Statement statement = this.db.statement();){
            ReadOperations readOperations = statement.readOperations();
            this.labelId = readOperations.labelGetForName(this.LABEL1.name());
            this.propertyId = readOperations.propertyKeyGetForName("Prop1");
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testThrowExceptionWhenIndexNotFound() throws SchemaRuleNotFoundException {
        try (Transaction ignored = this.db.beginTx();
             Statement statement = this.db.statement();){
            ReadOperations readOperations = statement.readOperations();
            try {
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
                readOperations.indexGetForSchema(descriptor);
                Assert.fail((String)"Should have failed");
            }
            catch (SchemaRuleNotFoundException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"No index was found for :label[1](property[2])"));
            }
        }
    }

    @Test
    public void indexGetProviderDescriptorMustReturnUndecidedIfIndexCreatedInTransaction() throws Exception {
        try (Transaction tx = this.db.beginTx();
             Statement statement = this.db.statement();){
            this.db.schema().indexFor(this.LABEL1).on("Prop1").create();
            ReadOperations readOperations = statement.readOperations();
            IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{this.propertyId});
            SchemaIndexProvider.Descriptor providerDescriptor = readOperations.indexGetProviderDescriptor(indexDescriptor);
            Assert.assertThat((Object)providerDescriptor, (Matcher)CoreMatchers.is((Object)SchemaIndexProvider.UNDECIDED));
            tx.success();
        }
    }

    @Test
    public void indexGetProviderDescriptorMustThrowIfIndexDoesNotExist() throws Exception {
        try (Transaction tx = this.db.beginTx();
             Statement statement = this.db.statement();){
            ReadOperations readOperations = statement.readOperations();
            IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{this.propertyId});
            try {
                readOperations.indexGetProviderDescriptor(indexDescriptor);
                Assert.fail((String)"Should have failed");
            }
            catch (IndexNotFoundKernelException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.containsString((String)"No index"), (Matcher)Matchers.containsString((String)(":label[" + this.labelId + "](property[" + this.propertyId + "])"))));
            }
            tx.success();
        }
    }
}

