/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.lock.ResourceType;

public class TwoPhaseNodeForRelationshipLockingTest {
    private final EntityReadOperations ops = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
    private final KernelStatement state = (KernelStatement)Mockito.mock(KernelStatement.class);
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final long nodeId = 42L;

    public TwoPhaseNodeForRelationshipLockingTest() {
        Mockito.when((Object)this.state.locks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        Mockito.when((Object)this.state.lockTracer()).thenReturn((Object)LockTracer.NONE);
    }

    @Test
    public void shouldLockNodesInOrderAndConsumeTheRelationships() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (ThrowingConsumer)collector);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.ops, this.state, 42L, false, new RelationshipData(21L, 42L, 43L), new RelationshipData(22L, 40L, 42L), new RelationshipData(23L, 42L, 41L), new RelationshipData(2L, 42L, 3L), new RelationshipData(3L, 49L, 42L), new RelationshipData(50L, 42L, 41L));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 40L, 41L, 42L, 43L, 49L});
        Assert.assertEquals((Object)Iterators.set((Object[])new Long[]{21L, 22L, 23L, 2L, 3L, 50L}), collector.set);
    }

    @Test
    public void shouldLockNodesInOrderAndConsumeTheRelationshipsAndRetryIfTheNewRelationshipsAreCreated() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (ThrowingConsumer)collector);
        RelationshipData relationship1 = new RelationshipData(21L, 42L, 43L);
        RelationshipData relationship2 = new RelationshipData(22L, 40L, 42L);
        RelationshipData relationship3 = new RelationshipData(23L, 42L, 41L);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.ops, this.state, 42L, true, relationship1, relationship2, relationship3);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{40L, 41L, 42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{40L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{41L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{40L, 41L, 42L, 43L});
        Assert.assertEquals((Object)Iterators.set((Object[])new Long[]{21L, 22L, 23L}), collector.set);
    }

    @Test
    public void lockNodeWithoutRelationships() throws Exception {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.ops, (ThrowingConsumer)collector);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.ops, this.state, 42L, false, new RelationshipData[0]);
        locking.lockAllNodesAndConsumeRelationships(42L, this.state);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    static void returnRelationships(EntityReadOperations ops, KernelStatement state, long nodeId, final boolean skipFirst, final RelationshipData ... relIds) throws EntityNotFoundException {
        final NodeItem nodeItem = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)ops.nodeGetRelationships(state, nodeItem, Direction.BOTH)).thenAnswer((Answer)new Answer<Cursor<RelationshipItem>>(){
            private boolean first;
            {
                this.first = skipFirst;
            }

            public Cursor<RelationshipItem> answer(InvocationOnMock invocation) throws Throwable {
                try {
                    Cursor<RelationshipItem> cursor = new Cursor<RelationshipItem>(){
                        private int i;
                        private RelationshipData relationshipData;
                        {
                            this.i = first ? 1 : 0;
                        }

                        public boolean next() {
                            boolean next = this.i < relIds.length;
                            this.relationshipData = next ? relIds[this.i++] : null;
                            return next;
                        }

                        public RelationshipItem get() {
                            if (this.relationshipData == null) {
                                throw new NoSuchElementException();
                            }
                            return this.relationshipData.asRelationshipItem();
                        }

                        public void close() {
                        }
                    };
                    return cursor;
                }
                finally {
                    this.first = false;
                }
            }
        });
        Mockito.when((Object)ops.nodeCursorById(state, nodeId)).thenAnswer(invocationOnMock -> {
            Cursor<NodeItem> cursor = new Cursor<NodeItem>(){
                private int i;

                public boolean next() {
                    return this.i++ == 0;
                }

                public NodeItem get() {
                    if (this.i != 1) {
                        throw new NoSuchElementException();
                    }
                    return nodeItem;
                }

                public void close() {
                }
            };
            if (!cursor.next()) {
                throw new EntityNotFoundException(EntityType.NODE, nodeId);
            }
            return cursor;
        });
    }

    private static class Collector
    implements ThrowingConsumer<Long, KernelException> {
        public final Set<Long> set = new HashSet<Long>();

        private Collector() {
        }

        public void accept(Long input) throws KernelException {
            Assert.assertNotNull((Object)input);
            this.set.add(input);
        }
    }

    public static class RelationshipData {
        public final long relId;
        public final long startNodeId;
        public final long endNodeId;

        RelationshipData(long relId, long startNodeId, long endNodeId) {
            this.relId = relId;
            this.startNodeId = startNodeId;
            this.endNodeId = endNodeId;
        }

        RelationshipItem asRelationshipItem() {
            RelationshipItem rel = (RelationshipItem)Mockito.mock(RelationshipItem.class);
            Mockito.when((Object)rel.id()).thenReturn((Object)this.relId);
            Mockito.when((Object)rel.startNode()).thenReturn((Object)this.startNodeId);
            Mockito.when((Object)rel.endNode()).thenReturn((Object)this.endNodeId);
            return rel;
        }
    }
}

