/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.values.storable.Values;

public class BatchingMultipleIndexPopulatorTest {
    public static final int propertyId = 1;
    public static final int labelId = 1;
    private final IndexDescriptor index1 = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    private final IndexDescriptor index42 = IndexDescriptorFactory.forLabel((int)42, (int[])new int[]{42});

    @After
    public void tearDown() throws Exception {
        BatchingMultipleIndexPopulatorTest.clearProperty("queue_threshold");
        BatchingMultipleIndexPopulatorTest.clearProperty("task_queue_size");
        BatchingMultipleIndexPopulatorTest.clearProperty("await_timeout_minutes");
        BatchingMultipleIndexPopulatorTest.clearProperty("batch_size");
    }

    @Test
    public void populateFromQueueDoesNothingIfThresholdNotReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 5);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)Mockito.mock(IndexStoreView.class), BatchingMultipleIndexPopulatorTest.immediateExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater);
        IndexEntryUpdate<LabelSchemaDescriptor> update1 = IndexQueryHelper.add(1L, this.index1.schema(), "foo");
        IndexEntryUpdate<LabelSchemaDescriptor> update2 = IndexQueryHelper.add(2L, this.index1.schema(), "bar");
        batchingPopulator.queue(update1);
        batchingPopulator.queue(update2);
        batchingPopulator.populateFromQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)Matchers.any());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).newPopulatingUpdater((PropertyAccessor)Matchers.any());
    }

    @Test
    public void populateFromQueuePopulatesWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 2);
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)storeView, BatchingMultipleIndexPopulatorTest.immediateExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator1.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater1);
        IndexPopulator populator2 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator2.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater2);
        batchingPopulator.indexAllNodes();
        IndexEntryUpdate<LabelSchemaDescriptor> update1 = IndexQueryHelper.add(1L, this.index1.schema(), "foo");
        IndexEntryUpdate<LabelSchemaDescriptor> update2 = IndexQueryHelper.add(2L, this.index42.schema(), "bar");
        IndexEntryUpdate<LabelSchemaDescriptor> update3 = IndexQueryHelper.add(3L, this.index1.schema(), "baz");
        batchingPopulator.queue(update1);
        batchingPopulator.queue(update2);
        batchingPopulator.queue(update3);
        batchingPopulator.populateFromQueue(42L);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update3);
        ((IndexUpdater)Mockito.verify((Object)updater2)).process(update2);
    }

    @Test
    public void executorShutdownAfterStoreScanCompletes() throws Exception {
        NodeUpdates update = this.nodeUpdates(1, 1, "foo", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = batchingPopulator.indexAllNodes();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        storeScan.run();
        ((ExecutorService)Mockito.verify((Object)executor)).shutdown();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
    }

    @Test
    public void executorForcefullyShutdownIfStoreScanFails() throws Exception {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        StoreScan failingStoreScan = (StoreScan)Mockito.mock(StoreScan.class);
        RuntimeException scanError = new RuntimeException();
        ((StoreScan)Mockito.doThrow((Throwable)scanError).when((Object)failingStoreScan)).run();
        Mockito.when((Object)storeView.visitNodes((int[])Matchers.any(), (IntPredicate)Matchers.any(), (Visitor)Matchers.any(), (Visitor)Matchers.any(), Matchers.anyBoolean())).thenReturn((Object)failingStoreScan);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = batchingPopulator.indexAllNodes();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        try {
            storeScan.run();
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertSame((Object)scanError, (Object)t);
        }
        ((ExecutorService)Mockito.verify((Object)executor)).shutdownNow();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
    }

    @Test
    public void pendingBatchesFlushedAfterStoreScan() throws Exception {
        NodeUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        NodeUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        NodeUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        NodeUpdates update42 = this.nodeUpdates(4, 42, "42", 42L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update42);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexPopulator populator42 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator1)).add(this.forUpdates(this.index1, update1, update2, update3));
        ((IndexPopulator)Mockito.verify((Object)populator42)).add(this.forUpdates(this.index42, update42));
    }

    @Test
    public void batchIsFlushedWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodeUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        NodeUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        NodeUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populatorMarkedAsFailed() throws Exception {
        IndexPopulator populator;
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodeUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        NodeUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
            populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
            List<IndexEntryUpdate<IndexDescriptor>> expected = this.forUpdates(this.index1, update1, update2);
            ((IndexPopulator)Mockito.doThrow((Throwable)batchFlushError).when((Object)populator)).add(expected);
            batchingPopulator.indexAllNodes().run();
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
    }

    @Test
    public void populatorMarkedAsFailedAndUpdatesNotAdded() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodeUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        NodeUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        NodeUpdates update3 = this.nodeUpdates(1, 1, "ccc", 1L);
        NodeUpdates update4 = this.nodeUpdates(1, 1, "ddd", 1L);
        NodeUpdates update5 = this.nodeUpdates(1, 1, "eee", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update4, update5);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        ((IndexPopulator)Mockito.doThrow((Throwable)batchFlushError).when((Object)populator)).add(this.forUpdates(this.index1, update3, update4));
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3, update4));
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).add(this.forUpdates(this.index1, update5));
    }

    @Test
    public void shouldApplyBatchesInParallel() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodeUpdates[] updates = new NodeUpdates[9];
        for (int i = 0; i < updates.length; ++i) {
            updates[i] = this.nodeUpdates(i, 1, String.valueOf(i), 1L);
        }
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(updates);
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.sameThreadExecutor();
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
        BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.indexAllNodes().run();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.atLeast((int)5))).execute((Runnable)Matchers.any(Runnable.class));
    }

    private List<IndexEntryUpdate<IndexDescriptor>> forUpdates(IndexDescriptor index, NodeUpdates ... updates) {
        return Iterables.asList((Iterable)Iterables.concat((Iterable)Iterables.map(update -> update.forIndexKeys(Iterables.asIterable((Object[])new IndexDescriptor[]{index})), Arrays.asList(updates))));
    }

    private NodeUpdates nodeUpdates(int nodeId, int propertyId, String propertyValue, long ... labelIds) {
        return NodeUpdates.forNode((long)nodeId, (long[])labelIds, (long[])labelIds).added(propertyId, Values.of((Object)propertyValue)).build();
    }

    private static IndexPopulator addPopulator(BatchingMultipleIndexPopulator batchingPopulator, IndexDescriptor descriptor) {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        batchingPopulator.addPopulator(populator, (long)descriptor.schema().getLabelId(), descriptor, new SchemaIndexProvider.Descriptor("foo", "1"), flipper, failedIndexProxyFactory, "testIndex");
        return populator;
    }

    private static IndexStoreView newStoreView(NodeUpdates ... updates) {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)storeView.visitNodes((int[])Matchers.any(), (IntPredicate)Matchers.any(), (Visitor)Matchers.any(), (Visitor)Matchers.any(), Matchers.anyBoolean())).thenAnswer(invocation -> {
            Object visitorArg = invocation.getArguments()[2];
            Visitor visitor = (Visitor)visitorArg;
            return new IndexEntryUpdateScan(updates, (Visitor<NodeUpdates, IndexPopulationFailedKernelException>)visitor);
        });
        return storeView;
    }

    private static ExecutorService sameThreadExecutor() throws InterruptedException {
        ExecutorService executor = BatchingMultipleIndexPopulatorTest.immediateExecutor();
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArguments()[0]).run();
            return null;
        }).when((Object)executor)).execute((Runnable)Matchers.any());
        return executor;
    }

    private static void setProperty(String name, int value) {
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)name, (Object)value);
    }

    private static void clearProperty(String name) {
        FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)name);
    }

    private static ExecutorService immediateExecutor() {
        ExecutorService result = (ExecutorService)Mockito.mock(ExecutorService.class);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgumentAt(0, Runnable.class)).run();
            return null;
        }).when((Object)result)).execute((Runnable)Matchers.any(Runnable.class));
        return result;
    }

    private static class IndexEntryUpdateScan
    implements StoreScan<IndexPopulationFailedKernelException> {
        final NodeUpdates[] updates;
        final Visitor<NodeUpdates, IndexPopulationFailedKernelException> visitor;
        boolean stop;

        IndexEntryUpdateScan(NodeUpdates[] updates, Visitor<NodeUpdates, IndexPopulationFailedKernelException> visitor) {
            this.updates = updates;
            this.visitor = visitor;
        }

        public void run() throws IndexPopulationFailedKernelException {
            for (NodeUpdates update : this.updates) {
                if (this.stop) {
                    return;
                }
                this.visitor.visit((Object)update);
            }
        }

        public void stop() {
            this.stop = true;
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }
    }
}

