/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;

public class IndexMapTest {
    private static final long[] noLabel = new long[0];
    private IndexMap indexMap;
    private LabelSchemaDescriptor schema3_4 = SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4});
    private LabelSchemaDescriptor schema5_6_7 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{6, 7});
    private LabelSchemaDescriptor schema5_8 = SchemaDescriptorFactory.forLabel((int)5, (int[])new int[]{8});

    @Before
    public void setup() {
        HashMap<Long, TestIndexProxy> map = new HashMap<Long, TestIndexProxy>();
        map.put(1L, new TestIndexProxy(this.schema3_4));
        map.put(2L, new TestIndexProxy(this.schema5_6_7));
        map.put(3L, new TestIndexProxy(this.schema5_8));
        this.indexMap = new IndexMap(map);
    }

    @Test
    public void shouldGetRelatedIndexForLabel() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(3L), noLabel, (PrimitiveIntCollection)PrimitiveIntCollections.emptySet()), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema3_4}));
    }

    @Test
    public void shouldGetRelatedIndexForProperty() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noLabel, this.label(3L, 4L, 5L), (PrimitiveIntCollection)this.properties(4)), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema3_4}));
    }

    @Test
    public void shouldGetRelatedIndexesForLabel() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(5L), this.label(3L, 4L), (PrimitiveIntCollection)PrimitiveIntCollections.emptySet()), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema5_6_7, this.schema5_8}));
    }

    @Test
    public void shouldGetRelatedIndexes() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(3L), this.label(4L, 5L), (PrimitiveIntCollection)this.properties(7)), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema3_4, this.schema5_6_7}));
    }

    @Test
    public void shouldGetRelatedIndexOnce() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(3L), noLabel, (PrimitiveIntCollection)this.properties(4)), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema3_4}));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noLabel, this.label(5L), (PrimitiveIntCollection)this.properties(6, 7)), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{this.schema5_6_7}));
    }

    @Test
    public void shouldHandleUnrelated() {
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noLabel, noLabel, (PrimitiveIntCollection)PrimitiveIntCollections.emptySet()), (Matcher)Matchers.emptyIterableOf(LabelSchemaDescriptor.class));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(2L), noLabel, (PrimitiveIntCollection)PrimitiveIntCollections.emptySet()), (Matcher)Matchers.emptyIterableOf(LabelSchemaDescriptor.class));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(noLabel, this.label(2L), (PrimitiveIntCollection)this.properties(1)), (Matcher)Matchers.emptyIterableOf(LabelSchemaDescriptor.class));
        MatcherAssert.assertThat((Object)this.indexMap.getRelatedIndexes(this.label(2L), this.label(2L), (PrimitiveIntCollection)this.properties(1)), (Matcher)Matchers.emptyIterableOf(LabelSchemaDescriptor.class));
    }

    private long[] label(long ... labels) {
        return labels;
    }

    private PrimitiveIntSet properties(int ... propertyIds) {
        return PrimitiveIntCollections.asSet((int[])propertyIds);
    }

    private class TestIndexProxy
    extends IndexProxyAdapter {
        private final LabelSchemaDescriptor schema;

        private TestIndexProxy(LabelSchemaDescriptor schema) {
            this.schema = schema;
        }

        @Override
        public LabelSchemaDescriptor schema() {
            return this.schema;
        }
    }
}

