/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.CollectingIndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexRecoveryIT {
    private GraphDatabaseAPI db;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final SchemaIndexProvider mockedIndexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final KernelExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory(TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR.getKey(), this.mockedIndexProvider);
    private final String key = "number_of_bananas_owned";
    private final Label myLabel = Label.label((String)"MyLabel");

    @Test
    public void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndex() throws Exception {
        this.startDb();
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.createIndex(this.myLabel);
        Future<Void> killFuture = this.killDbInSeparateThread();
        latch.countDown();
        killFuture.get();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.POPULATING);
        latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.POPULATING)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)0))).getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        latch.countDown();
    }

    @Test
    public void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndexWhereLogHasRotated() throws Exception {
        this.startDb();
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.createIndex(this.myLabel);
        this.rotateLogsAndCheckPoint();
        Future<Void> killFuture = this.killDbInSeparateThread();
        latch.countDown();
        killFuture.get();
        latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.POPULATING);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.POPULATING)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)0))).getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        latch.countDown();
    }

    @Test
    public void shouldBeAbleToRecoverAndUpdateOnlineIndex() throws Exception {
        this.startDb();
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        IndexAccessor mockedAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)mockedAccessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)SwallowingIndexUpdater.INSTANCE);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)mockedAccessor);
        this.createIndexAndAwaitPopulation(this.myLabel);
        this.rotateLogsAndCheckPoint();
        Set<IndexEntryUpdate<?>> expectedUpdates = this.createSomeBananas(this.myLabel);
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.ONLINE)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)1))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        int onlineAccessorInvocationCount = 2;
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)onlineAccessorInvocationCount))).getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        Assert.assertEquals(expectedUpdates, (Object)writer.batchedUpdates);
    }

    @Test
    public void shouldKeepFailedIndexesAsFailedAfterRestart() throws Exception {
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn(Mockito.mock(IndexPopulator.class));
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn(Mockito.mock(IndexAccessor.class));
        this.startDb();
        this.createIndex(this.myLabel);
        this.rotateLogsAndCheckPoint();
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.FAILED);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.FAILED)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.compareTo((SchemaIndexProvider)Matchers.any(SchemaIndexProvider.class))).thenReturn((Object)1);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), (PageCache)Matchers.any(PageCache.class))).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
    }

    private void startDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fs.get());
        factory.setKernelExtensions(Arrays.asList(this.mockedIndexProviderFactory));
        this.db = (GraphDatabaseAPI)factory.newImpermanentDatabase();
    }

    private void killDb() throws Exception {
        if (this.db != null) {
            this.fs.snapshot(() -> {
                this.db.shutdown();
                this.db = null;
            });
        }
    }

    private Future<Void> killDbInSeparateThread() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(() -> {
            this.killDb();
            return null;
        });
        executor.shutdown();
        return result;
    }

    @After
    public void after() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    private void rotateLogsAndCheckPoint() throws IOException {
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void createIndexAndAwaitPopulation(Label label) {
        IndexDefinition index = this.createIndex(label);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private IndexDefinition createIndex(Label label) {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = this.db.schema().indexFor(label).on("number_of_bananas_owned").create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private Set<IndexEntryUpdate<?>> createSomeBananas(Label label) {
        HashSet updates = new HashSet();
        try (Transaction tx = this.db.beginTx();){
            ThreadToStatementContextBridge ctxSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = ctxSupplier.get();){
                int labelId = statement.readOperations().labelGetForName(label.name());
                int propertyKeyId = statement.readOperations().propertyKeyGetForName("number_of_bananas_owned");
                LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
                for (int number : new int[]{4, 10}) {
                    Node node = this.db.createNode(new Label[]{label});
                    node.setProperty("number_of_bananas_owned", (Object)number);
                    updates.add(IndexEntryUpdate.add((long)node.getId(), (LabelSchemaSupplier)schemaDescriptor, (Value[])new Value[]{Values.of((Object)number)}));
                }
            }
            tx.success();
            HashSet hashSet = updates;
            return hashSet;
        }
    }

    private IndexPopulator indexPopulatorWithControlledCompletionTiming(final CountDownLatch latch) {
        return new IndexPopulator.Adapter(){

            public void create() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new RuntimeException("this is expected");
            }
        };
    }

    public static class GatheringIndexWriter
    extends IndexAccessor.Adapter {
        private final Set<IndexEntryUpdate<?>> regularUpdates = new HashSet();
        private final Set<IndexEntryUpdate<?>> batchedUpdates = new HashSet();

        public IndexUpdater newUpdater(final IndexUpdateMode mode) {
            return new CollectingIndexUpdater(){

                public void close() throws IOException, IndexEntryConflictException {
                    switch (mode) {
                        case ONLINE: {
                            regularUpdates.addAll(this.updates);
                            break;
                        }
                        case RECOVERY: {
                            batchedUpdates.addAll(this.updates);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
            };
        }
    }
}

