/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IndexStatisticsIT {
    private static final Label ALIEN = Label.label((String)"Alien");
    private static final String SPECIMEN = "specimen";
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final InMemoryIndexProvider indexProvider = new InMemoryIndexProvider(100);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private GraphDatabaseService db;

    @Before
    public void before() {
        this.setupDb((EphemeralFileSystemAbstraction)this.fsRule.get());
    }

    @After
    public void after() {
        try {
            this.db.shutdown();
        }
        finally {
            this.db = null;
        }
    }

    @Test
    public void shouldRecoverIndexCountsBySamplingThemOnStartup() {
        this.createAliens();
        this.awaitIndexOnline(this.indexAliensBySpecimen());
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)this.labelId(ALIEN), (int[])new int[]{this.pkId(SPECIMEN)});
        SchemaStorage storage = new SchemaStorage((RecordStore)this.neoStores().getSchemaStore());
        long indexId = storage.indexGetForSchema(index).getId();
        this.resetIndexCounts(indexId);
        this.restart();
        CountsTracker tracker = this.neoStores().getCounts();
        this.assertEqualRegisters("Unexpected updates and size for the index", Registers.newDoubleLongRegister((long)0L, (long)32L), tracker.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
        this.assertEqualRegisters("Unexpected sampling result", Registers.newDoubleLongRegister((long)16L, (long)32L), tracker.indexSample(indexId, Registers.newDoubleLongRegister()));
        this.assertLogExistsForRecoveryOn(":Alien(specimen)");
    }

    private void assertEqualRegisters(String message, Register.DoubleLongRegister expected, Register.DoubleLongRegister actual) {
        Assert.assertEquals((String)(message + " (first part of register)"), (long)expected.readFirst(), (long)actual.readFirst());
        Assert.assertEquals((String)(message + " (second part of register)"), (long)expected.readSecond(), (long)actual.readSecond());
    }

    private void assertLogExistsForRecoveryOn(String labelAndProperty) {
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexSamplingController.class).debug("Recovering index sampling for index %s", new Object[]{labelAndProperty})});
    }

    /*
     * Exception decompiling
     */
    private int labelId(Label alien) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int pkId(String propertyName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Statement statement() {
        return ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).get();
    }

    private void createAliens() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 32; ++i) {
                Node alien = this.db.createNode(new Label[]{ALIEN});
                alien.setProperty(SPECIMEN, (Object)(i / 2));
            }
            tx.success();
        }
    }

    private void awaitIndexOnline(IndexDefinition definition) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(definition, 10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private IndexDefinition indexAliensBySpecimen() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition definition = this.db.schema().indexFor(ALIEN).on(SPECIMEN).create();
            tx.success();
            IndexDefinition indexDefinition = definition;
            return indexDefinition;
        }
    }

    private void resetIndexCounts(long indexId) {
        try (CountsAccessor.IndexStatsUpdater updater = this.neoStores().getCounts().updateIndexCounts();){
            updater.replaceIndexSample(indexId, 0L, 0L);
            updater.replaceIndexUpdateAndSize(indexId, 0L, 0L);
        }
    }

    private NeoStores neoStores() {
        return ((RecordStorageEngine)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    private void setupDb(EphemeralFileSystemAbstraction fs) {
        this.db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)this.logProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)fs)).setKernelExtensions(Arrays.asList(new KernelExtensionFactory[]{new InMemoryIndexProviderFactory(this.indexProvider)})).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.index_background_sampling_enabled, "false").newGraphDatabase();
    }

    public void restart() {
        this.db.shutdown();
        this.setupDb(((EphemeralFileSystemAbstraction)this.fsRule.get()).snapshot());
    }
}

