/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collections;
import java.util.function.IntPredicate;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleIndexPopulatorUpdatesTest {
    @Mock(answer=Answers.RETURNS_MOCKS)
    private LogProvider logProvider;

    @Test
    public void updateForHigherNodeIgnoredWhenUsingFullNodeStoreScan() throws IndexPopulationFailedKernelException, IOException, IndexEntryConflictException {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        CountsTracker countsTracker = (CountsTracker)Mockito.mock(CountsTracker.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        NodeRecord nodeRecord = this.getNodeRecord();
        PropertyRecord propertyRecord = this.getPropertyRecord();
        Mockito.when((Object)neoStores.getCounts()).thenReturn((Object)countsTracker);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        Mockito.when((Object)neoStores.getPropertyStore()).thenReturn((Object)propertyStore);
        Mockito.when((Object)propertyStore.getPropertyRecordChain((long)Matchers.anyInt())).thenReturn(Collections.singletonList(propertyRecord));
        Mockito.when((Object)countsTracker.nodeCount(Matchers.anyInt(), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)3L, (long)3L));
        Mockito.when((Object)nodeStore.getHighestPossibleIdInUse()).thenReturn((Object)20L);
        Mockito.when((Object)nodeStore.newRecord()).thenReturn((Object)nodeRecord);
        Mockito.when((Object)nodeStore.getRecord((long)Matchers.anyInt(), (AbstractBaseRecord)Matchers.eq((Object)nodeRecord), (RecordLoad)Matchers.any(RecordLoad.class))).thenAnswer((Answer)new SetNodeIdRecordAnswer(nodeRecord, 1L));
        Mockito.when((Object)nodeStore.getRecord(Matchers.eq((long)7L), (AbstractBaseRecord)Matchers.eq((Object)nodeRecord), (RecordLoad)Matchers.any(RecordLoad.class))).thenAnswer((Answer)new SetNodeIdRecordAnswer(nodeRecord, 7L));
        ProcessListenableNeoStoreIndexView storeView = new ProcessListenableNeoStoreIndexView(LockService.NO_LOCK_SERVICE, neoStores);
        MultipleIndexPopulator indexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, this.logProvider);
        storeView.setProcessListener(new NodeUpdateProcessListener(indexPopulator));
        IndexPopulator populator = this.createIndexPopulator();
        IndexUpdater indexUpdater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((PropertyAccessor)storeView)).thenReturn((Object)indexUpdater);
        this.addPopulator(indexPopulator, populator, 1L, IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1}));
        indexPopulator.create();
        StoreScan storeScan = indexPopulator.indexAllNodes();
        storeScan.run();
        ((IndexUpdater)Mockito.verify((Object)indexUpdater, (VerificationMode)Mockito.times((int)0))).process((IndexEntryUpdate)Matchers.any(IndexEntryUpdate.class));
    }

    private NodeRecord getNodeRecord() {
        NodeRecord nodeRecord = new NodeRecord(1L);
        nodeRecord.initialize(true, 0L, false, 1L, 1L);
        InlineNodeLabels.putSorted((NodeRecord)nodeRecord, (long[])new long[]{1L}, null, null);
        return nodeRecord;
    }

    private PropertyRecord getPropertyRecord() {
        PropertyRecord propertyRecord = new PropertyRecord(1L);
        PropertyBlock propertyBlock = new PropertyBlock();
        propertyBlock.setValueBlocks(new long[]{0L});
        propertyBlock.setKeyIndexId(1);
        propertyBlock.setSingleBlock(4222124801654785L);
        propertyRecord.setPropertyBlock(propertyBlock);
        return propertyRecord;
    }

    private IndexPopulator createIndexPopulator() {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        return populator;
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, long indexId, IndexDescriptor descriptor) {
        return this.addPopulator(multipleIndexPopulator, indexId, descriptor, indexPopulator, (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class), (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, long indexId, IndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return multipleIndexPopulator.addPopulator(indexPopulator, indexId, descriptor, (SchemaIndexProvider.Descriptor)Mockito.mock(SchemaIndexProvider.Descriptor.class), flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private class ListenableNodeScanViewNodeStoreScan<FAILURE extends Exception>
    extends StoreViewNodeStoreScan<FAILURE> {
        private final Listener<NodeRecord> processListener;

        ListenableNodeScanViewNodeStoreScan(NodeStore nodeStore, LockService locks, PropertyStore propertyStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<NodeUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, Listener<NodeRecord> processListener) {
            super(nodeStore, locks, propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
            this.processListener = processListener;
        }

        public void process(NodeRecord nodeRecord) throws FAILURE {
            this.processListener.receive((Object)nodeRecord);
            super.process(nodeRecord);
        }
    }

    private class ProcessListenableNeoStoreIndexView
    extends NeoStoreIndexStoreView {
        private Listener<NodeRecord> processListener;

        ProcessListenableNeoStoreIndexView(LockService locks, NeoStores neoStores) {
            super(locks, neoStores);
        }

        public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<NodeUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
            return new ListenableNodeScanViewNodeStoreScan<FAILURE>(this.nodeStore, this.locks, this.propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, this.processListener);
        }

        public void setProcessListener(Listener<NodeRecord> processListener) {
            this.processListener = processListener;
        }
    }

    private static class NodeUpdateProcessListener
    implements Listener<NodeRecord> {
        private final MultipleIndexPopulator indexPopulator;
        private final LabelSchemaDescriptor index;

        NodeUpdateProcessListener(MultipleIndexPopulator indexPopulator) {
            this.indexPopulator = indexPopulator;
            this.index = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        }

        public void receive(NodeRecord nodeRecord) {
            if (nodeRecord.getId() == 7L) {
                this.indexPopulator.queue(IndexEntryUpdate.change((long)8L, (LabelSchemaSupplier)this.index, (Value)Values.of((Object)"a"), (Value)Values.of((Object)"b")));
            }
        }
    }

    private static class SetNodeIdRecordAnswer
    implements Answer<NodeRecord> {
        private final NodeRecord nodeRecord;
        private final long id;

        SetNodeIdRecordAnswer(NodeRecord nodeRecord, long id) {
            this.nodeRecord = nodeRecord;
            this.id = id;
        }

        public NodeRecord answer(InvocationOnMock invocation) throws Throwable {
            this.nodeRecord.setId(this.id);
            return this.nodeRecord;
        }
    }
}

