/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

public class UpdatesTracker {
    private int created;
    private int deleted;
    private int createdDuringPopulation;
    private int deletedDuringPopulation;
    private boolean populationCompleted;

    public void increaseCreated(int num) {
        this.created += num;
    }

    public void increaseDeleted(int num) {
        this.deleted += num;
    }

    void notifyPopulationCompleted() {
        if (this.populationCompleted) {
            return;
        }
        this.populationCompleted = true;
        this.createdDuringPopulation = this.created;
        this.deletedDuringPopulation = this.deleted;
    }

    public boolean isPopulationCompleted() {
        return this.populationCompleted;
    }

    public int created() {
        return this.created;
    }

    public int deleted() {
        return this.deleted;
    }

    public int createdDuringPopulation() {
        return this.createdDuringPopulation;
    }

    public int deletedDuringPopulation() {
        return this.deletedDuringPopulation;
    }

    public int createdAfterPopulation() {
        return this.created - this.createdDuringPopulation;
    }

    public int deletedAfterPopulation() {
        return this.deleted - this.deletedDuringPopulation;
    }

    public void add(UpdatesTracker updatesTracker) {
        assert (this.isPopulationCompleted());
        assert (updatesTracker.isPopulationCompleted());
        this.created += updatesTracker.created;
        this.deleted += updatesTracker.deleted;
        this.createdDuringPopulation += updatesTracker.createdDuringPopulation;
        this.deletedDuringPopulation += updatesTracker.deletedDuringPopulation;
    }

    public String toString() {
        return "UpdatesTracker{created=" + this.created + ", deleted=" + this.deleted + ", createdDuringPopulation=" + this.createdDuringPopulation + ", deletedDuringPopulation=" + this.deletedDuringPopulation + ", populationCompleted=" + this.populationCompleted + '}';
    }
}

