/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;

class InMemoryIndex {
    protected final InMemoryIndexImplementation indexData;
    private InternalIndexState state = InternalIndexState.POPULATING;
    String failure;

    InMemoryIndex() {
        this(new HashBasedIndex());
    }

    private InMemoryIndex(InMemoryIndexImplementation indexData) {
        this.indexData = indexData;
    }

    public String toString() {
        if (this.failure != null) {
            return String.format("%s[failure=\"%s\"]%s", this.getClass().getSimpleName(), this.failure, this.indexData);
        }
        return String.format("%s%s", this.getClass().getSimpleName(), this.indexData);
    }

    final IndexPopulator getPopulator() {
        return new Populator();
    }

    final IndexAccessor getOnlineAccessor() {
        return new OnlineAccessor();
    }

    protected boolean add(long nodeId, Value[] propertyValues, boolean applyIdempotently) {
        assert (propertyValues.length > 0);
        return this.indexData.add(nodeId, applyIdempotently, propertyValues);
    }

    protected void remove(long nodeId, Value[] propertyValues) {
        assert (propertyValues.length > 0);
        this.indexData.remove(nodeId, propertyValues);
    }

    protected void remove(long nodeId) {
        this.indexData.remove(nodeId);
    }

    InternalIndexState getState() {
        return this.state;
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    protected IndexUpdater newUpdater(IndexUpdateMode mode, boolean populating) {
        return new InMemoryIndexUpdater(populating);
    }

    InMemoryIndex snapshot() {
        InMemoryIndex snapshot = new InMemoryIndex(this.indexData.snapshot());
        snapshot.failure = this.failure;
        snapshot.state = this.state;
        return snapshot;
    }

    static String encodeAsString(Object propertyValue) {
        String repr = propertyValue instanceof int[] ? Arrays.toString((int[])propertyValue) : (propertyValue instanceof long[] ? Arrays.toString((long[])propertyValue) : (propertyValue instanceof boolean[] ? Arrays.toString((boolean[])propertyValue) : (propertyValue instanceof double[] ? Arrays.toString((double[])propertyValue) : (propertyValue instanceof float[] ? Arrays.toString((float[])propertyValue) : (propertyValue instanceof short[] ? Arrays.toString((short[])propertyValue) : (propertyValue instanceof byte[] ? Arrays.toString((byte[])propertyValue) : (propertyValue instanceof char[] ? Arrays.toString((char[])propertyValue) : (propertyValue instanceof Object[] ? Arrays.toString((Object[])propertyValue) : propertyValue.toString()))))))));
        return repr;
    }

    boolean hasSameContentsAs(InMemoryIndex otherIndex) {
        return this.indexData.hasSameContentsAs(otherIndex.indexData);
    }

    private class InMemoryIndexUpdater
    implements IndexUpdater {
        private final boolean applyIdempotently;

        private InMemoryIndexUpdater(boolean applyIdempotently) {
            this.applyIdempotently = applyIdempotently;
        }

        public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
            switch (update.updateMode()) {
                case ADDED: {
                    InMemoryIndex.this.add(update.getEntityId(), update.values(), this.applyIdempotently);
                    break;
                }
                case CHANGED: {
                    InMemoryIndex.this.remove(update.getEntityId(), update.beforeValues());
                    InMemoryIndex.this.add(update.getEntityId(), update.values(), this.applyIdempotently);
                    break;
                }
                case REMOVED: {
                    InMemoryIndex.this.remove(update.getEntityId(), update.values());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void close() throws IOException, IndexEntryConflictException {
        }
    }

    private class OnlineAccessor
    implements IndexAccessor {
        private OnlineAccessor() {
        }

        public void force(IOLimiter ioLimiter) {
        }

        public void refresh() {
        }

        public void drop() {
            InMemoryIndex.this.indexData.drop();
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return InMemoryIndex.this.newUpdater(mode, false);
        }

        public void close() {
        }

        public IndexReader newReader() {
            return InMemoryIndex.this.indexData;
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            return InMemoryIndex.this.indexData;
        }

        public ResourceIterator<File> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
            InMemoryIndex.this.verifyDeferredConstraints(propertyAccessor);
        }

        public boolean isDirty() {
            return false;
        }
    }

    private class Populator
    implements IndexPopulator {
        private Populator() {
        }

        public void create() {
            InMemoryIndex.this.indexData.initialize();
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
            for (IndexEntryUpdate<?> update : updates) {
                InMemoryIndex.this.add(update.getEntityId(), update.values(), false);
            }
        }

        public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
            InMemoryIndex.this.verifyDeferredConstraints(accessor);
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
            return InMemoryIndex.this.newUpdater(IndexUpdateMode.ONLINE, true);
        }

        public void drop() throws IOException {
            InMemoryIndex.this.indexData.drop();
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            if (populationCompletedSuccessfully) {
                InMemoryIndex.this.state = InternalIndexState.ONLINE;
            }
        }

        public void markAsFailed(String failureString) {
            InMemoryIndex.this.failure = failureString;
            InMemoryIndex.this.state = InternalIndexState.FAILED;
        }

        public void includeSample(IndexEntryUpdate<?> update) {
        }

        public IndexSample sampleResult() {
            try {
                return InMemoryIndex.this.indexData.createSampler().sampleIndex();
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

