/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.kernel.impl.api.index.updater.UniquePropertyIndexUpdater;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

class UniqueInMemoryIndex
extends InMemoryIndex {
    private final LabelSchemaDescriptor schema;

    UniqueInMemoryIndex(LabelSchemaDescriptor schema) {
        this.schema = schema;
    }

    @Override
    protected IndexUpdater newUpdater(final IndexUpdateMode mode, boolean populating) {
        return new UniquePropertyIndexUpdater(){

            protected void flushUpdates(Iterable<IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
                for (IndexEntryUpdate<?> update : updates) {
                    switch (update.updateMode()) {
                        case CHANGED: {
                            UniqueInMemoryIndex.this.remove(update.getEntityId(), update.beforeValues());
                            break;
                        }
                        case REMOVED: {
                            UniqueInMemoryIndex.this.remove(update.getEntityId(), update.values());
                            break;
                        }
                    }
                }
                for (IndexEntryUpdate<?> update : updates) {
                    switch (update.updateMode()) {
                        case ADDED: {
                            UniqueInMemoryIndex.this.add(update.getEntityId(), update.values(), IndexUpdateMode.ONLINE == mode);
                            break;
                        }
                        case CHANGED: {
                            UniqueInMemoryIndex.this.add(update.getEntityId(), update.values(), IndexUpdateMode.ONLINE == mode);
                            break;
                        }
                    }
                }
            }
        };
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        try {
            if (this.schema.getPropertyIds().length == 1) {
                this.indexData.iterateAll(new SinglePropertyValidator(accessor));
            } else {
                this.indexData.iterateAll(new MultiPropertyValidator(accessor));
            }
        }
        catch (IndexEntryConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class MultiPropertyValidator
    implements InMemoryIndexImplementation.IndexEntryIterator {
        private final PropertyAccessor accessor;

        MultiPropertyValidator(PropertyAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public void visitEntry(Object key, Set<Long> nodeIds) throws Exception {
            HashMap<ValueTuple, Long> entries = new HashMap<ValueTuple, Long>();
            for (long nodeId : nodeIds) {
                ValueTuple values = this.getValues(nodeId);
                if (entries.containsKey(values)) {
                    long existingNodeId = (Long)entries.get(values);
                    throw new IndexEntryConflictException(existingNodeId, nodeId, values);
                }
                entries.put(values, nodeId);
            }
        }

        ValueTuple getValues(long nodeId) throws EntityNotFoundException {
            int[] propertyIds = UniqueInMemoryIndex.this.schema.getPropertyIds();
            Value[] values = new Value[propertyIds.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.accessor.getPropertyValue(nodeId, propertyIds[i]);
            }
            return ValueTuple.of((Value[])values);
        }
    }

    private class SinglePropertyValidator
    implements InMemoryIndexImplementation.IndexEntryIterator {
        private final PropertyAccessor accessor;

        SinglePropertyValidator(PropertyAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public void visitEntry(Object key, Set<Long> nodeIds) throws Exception {
            HashMap<Value, Long> entries = new HashMap<Value, Long>();
            for (long nodeId : nodeIds) {
                Value value = this.accessor.getPropertyValue(nodeId, UniqueInMemoryIndex.this.schema.getPropertyId());
                if (entries.containsKey(value)) {
                    long existingNodeId = (Long)entries.get(value);
                    throw new IndexEntryConflictException(existingNodeId, nodeId, ValueTuple.of((Value[])new Value[]{value}));
                }
                entries.put(value, nodeId);
            }
        }
    }
}

