/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.inmemory.UpdateCapturingIndexAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

public class UpdateCapturingIndexProvider
extends SchemaIndexProvider {
    private final SchemaIndexProvider actual;
    private final Map<Long, UpdateCapturingIndexAccessor> indexes = new ConcurrentHashMap<Long, UpdateCapturingIndexAccessor>();
    private final Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates;

    public UpdateCapturingIndexProvider(SchemaIndexProvider actual, Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates) {
        super(actual);
        this.actual = actual;
        this.initialUpdates = initialUpdates;
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return this.actual.getPopulator(indexId, descriptor, samplingConfig);
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        IndexAccessor actualAccessor = this.actual.getOnlineAccessor(indexId, descriptor, samplingConfig);
        return this.indexes.computeIfAbsent(indexId, id -> new UpdateCapturingIndexAccessor(actualAccessor, this.initialUpdates.get(id)));
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        return this.actual.getPopulationFailure(indexId);
    }

    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        return this.actual.getInitialState(indexId, descriptor);
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return this.actual.storeMigrationParticipant(fs, pageCache);
    }

    public Map<Long, Collection<IndexEntryUpdate<?>>> snapshot() {
        HashMap result = new HashMap();
        this.indexes.forEach((indexId, index) -> result.put((Long)indexId, index.snapshot()));
        return result;
    }
}

