/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.DoubleLatch;

public class IndexSamplingControllerTest {
    private final IndexSamplingConfig samplingConfig = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);
    private final IndexSamplingJobFactory jobFactory = (IndexSamplingJobFactory)Mockito.mock(IndexSamplingJobFactory.class);
    private final IndexSamplingJobQueue<Long> jobQueue = new IndexSamplingJobQueue(Predicates.alwaysTrue());
    private final IndexSamplingJobTracker tracker = (IndexSamplingJobTracker)Mockito.mock(IndexSamplingJobTracker.class);
    private final JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final IndexMapSnapshotProvider snapshotProvider = (IndexMapSnapshotProvider)Mockito.mock(IndexMapSnapshotProvider.class);
    private final IndexMap indexMap = new IndexMap();
    private final long indexId = 2L;
    private final long anotherIndexId = 3L;
    private final IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexProxy anotherIndexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexDescriptor descriptor = IndexDescriptorFactory.forLabel((int)3, (int[])new int[]{4});
    private final IndexDescriptor anotherDescriptor = IndexDescriptorFactory.forLabel((int)5, (int[])new int[]{6});
    private final IndexSamplingJob job = (IndexSamplingJob)Mockito.mock(IndexSamplingJob.class);
    private final IndexSamplingJob anotherJob = (IndexSamplingJob)Mockito.mock(IndexSamplingJob.class);

    public IndexSamplingControllerTest() {
        Mockito.when((Object)this.samplingConfig.backgroundSampling()).thenReturn((Object)true);
        Mockito.when((Object)this.samplingConfig.jobLimit()).thenReturn((Object)1);
        Mockito.when((Object)this.indexProxy.getDescriptor()).thenReturn((Object)this.descriptor);
        Mockito.when((Object)this.anotherIndexProxy.getDescriptor()).thenReturn((Object)this.anotherDescriptor);
        Mockito.when((Object)this.snapshotProvider.indexMapSnapshot()).thenReturn((Object)this.indexMap);
        Mockito.when((Object)this.jobFactory.create(2L, this.indexProxy)).thenReturn((Object)this.job);
        Mockito.when((Object)this.jobFactory.create(3L, this.anotherIndexProxy)).thenReturn((Object)this.anotherJob);
        this.indexMap.putIndexProxy(2L, this.indexProxy);
    }

    @Test
    public void shouldStartASamplingJobForEachIndexInTheDB() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)2))).canExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldNotStartAJobIfTheIndexIsNotOnline() throws InterruptedException {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        controller.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)2))).canExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldNotStartAJobIfTheTrackerCannotHandleIt() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)false);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)1))).canExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldNotEmptyQueueConcurrently() {
        AtomicInteger totalCount = new AtomicInteger(0);
        AtomicInteger concurrentCount = new AtomicInteger(0);
        DoubleLatch jobLatch = new DoubleLatch();
        DoubleLatch testLatch = new DoubleLatch();
        ThreadLocal<Boolean> hasRun = ThreadLocal.withInitial(() -> false);
        IndexSamplingJobFactory jobFactory = (indexId, proxy) -> {
            if (((Boolean)hasRun.get()).booleanValue()) {
                return null;
            }
            hasRun.set(true);
            if (!concurrentCount.compareAndSet(0, 1)) {
                throw new IllegalStateException("count !== 0 on create");
            }
            totalCount.incrementAndGet();
            jobLatch.waitForAllToStart();
            testLatch.startAndWaitForAllToStart();
            jobLatch.waitForAllToFinish();
            concurrentCount.decrementAndGet();
            testLatch.finish();
            return null;
        };
        IndexSamplingController controller = new IndexSamplingController(this.samplingConfig, jobFactory, this.jobQueue, this.tracker, this.snapshotProvider, this.scheduler, this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        new Thread(this.runController(controller, IndexSamplingMode.BACKGROUND_REBUILD_UPDATED)).start();
        jobLatch.startAndWaitForAllToStart();
        testLatch.waitForAllToStart();
        Assert.assertEquals((long)1L, (long)concurrentCount.get());
        Assert.assertEquals((long)1L, (long)totalCount.get());
        controller.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        jobLatch.finish();
        testLatch.waitForAllToFinish();
        Assert.assertEquals((long)0L, (long)concurrentCount.get());
        Assert.assertEquals((long)1L, (long)totalCount.get());
    }

    @Test
    public void shouldSampleAllTheIndexes() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(3L, this.anotherIndexProxy);
        controller.sampleIndexes(IndexSamplingMode.TRIGGER_REBUILD_UPDATED);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(3L, this.anotherIndexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.anotherJob);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)2))).waitUntilCanExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldSampleAllTheOnlineIndexes() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        this.indexMap.putIndexProxy(3L, this.anotherIndexProxy);
        controller.sampleIndexes(IndexSamplingMode.TRIGGER_REBUILD_UPDATED);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)2))).waitUntilCanExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldNotStartOtherSamplingWhenSamplingAllTheIndexes() {
        AtomicInteger totalCount = new AtomicInteger(0);
        AtomicInteger concurrentCount = new AtomicInteger(0);
        DoubleLatch jobLatch = new DoubleLatch();
        DoubleLatch testLatch = new DoubleLatch();
        IndexSamplingJobFactory jobFactory = (indexId, proxy) -> {
            if (!concurrentCount.compareAndSet(0, 1)) {
                throw new IllegalStateException("count !== 0 on create");
            }
            totalCount.incrementAndGet();
            jobLatch.waitForAllToStart();
            testLatch.startAndWaitForAllToStart();
            jobLatch.waitForAllToFinish();
            concurrentCount.decrementAndGet();
            testLatch.finish();
            return null;
        };
        IndexSamplingController controller = new IndexSamplingController(this.samplingConfig, jobFactory, this.jobQueue, this.tracker, this.snapshotProvider, this.scheduler, this.always(true));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        new Thread(this.runController(controller, IndexSamplingMode.TRIGGER_REBUILD_UPDATED)).start();
        jobLatch.startAndWaitForAllToStart();
        testLatch.waitForAllToStart();
        Assert.assertEquals((long)1L, (long)concurrentCount.get());
        controller.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        jobLatch.finish();
        testLatch.waitForAllToFinish();
        Assert.assertEquals((long)0L, (long)concurrentCount.get());
        Assert.assertEquals((long)1L, (long)totalCount.get());
    }

    @Test
    public void shouldRecoverOnlineIndex() {
        IndexSamplingController controller = this.newSamplingController(this.always(true));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.recoverIndexSamples();
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJob)Mockito.verify((Object)this.job)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    public void shouldNotRecoverOfflineIndex() {
        IndexSamplingController controller = this.newSamplingController(this.always(true));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.FAILED);
        controller.recoverIndexSamples();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    public void shouldNotRecoverOnlineIndexIfNotNeeded() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.recoverIndexSamples();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    public void shouldSampleIndex() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(3L, this.anotherIndexProxy);
        controller.sampleIndex(2L, IndexSamplingMode.TRIGGER_REBUILD_UPDATED);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory, (VerificationMode)Mockito.times((int)1))).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)1))).scheduleSamplingJob(this.job);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory, (VerificationMode)Mockito.never())).create(3L, this.anotherIndexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.never())).scheduleSamplingJob(this.anotherJob);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)1))).waitUntilCanExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    public void shouldNotStartForSingleIndexAJobIfTheTrackerCannotHandleIt() {
        IndexSamplingController controller = this.newSamplingController(this.always(false));
        Mockito.when((Object)this.tracker.canExecuteMoreSamplingJobs()).thenReturn((Object)false);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.sampleIndex(2L, IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.times((int)1))).canExecuteMoreSamplingJobs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    private IndexSamplingController.RecoveryCondition always(boolean ans) {
        return new Always(ans);
    }

    private IndexSamplingController newSamplingController(IndexSamplingController.RecoveryCondition recoveryPredicate) {
        return new IndexSamplingController(this.samplingConfig, this.jobFactory, this.jobQueue, this.tracker, this.snapshotProvider, this.scheduler, recoveryPredicate);
    }

    private Runnable runController(IndexSamplingController controller, IndexSamplingMode mode) {
        return () -> controller.sampleIndexes(mode);
    }

    private static class Always
    implements IndexSamplingController.RecoveryCondition {
        private final boolean ans;

        Always(boolean ans) {
            this.ans = ans;
        }

        public boolean test(long indexId, IndexDescriptor descriptor) {
            return this.ans;
        }
    }
}

