/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.internal.Version;

public class BuiltInProceduresIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void listAllLabels() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName("MyLabel");
        statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyLabel"})));
    }

    @Test
    public void listPropertyKeys() throws Throwable {
        TokenWriteOperations ops = this.tokenWriteOperationsInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyProp"})));
    }

    @Test
    public void listRelationshipTypes() throws Throwable {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relType = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().relationshipCreate(relType, startNodeId, endNodeId);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyRelType"})));
    }

    @Test
    public void listProcedures() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "procedures"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"dbms.listConfig", "dbms.listConfig(searchString =  :: STRING?) :: (name :: STRING?, description :: STRING?, value :: STRING?)", "List the currently active config of Neo4j."}), IsEqual.equalTo((Object)new Object[]{"db.constraints", "db.constraints() :: (description :: STRING?)", "List all constraints in the database."}), IsEqual.equalTo((Object)new Object[]{"db.indexes", "db.indexes() :: (description :: STRING?, label :: STRING?, properties :: LIST? OF STRING?, state :: STRING?, type :: STRING?, provider :: MAP?)", "List all indexes in the database."}), IsEqual.equalTo((Object)new Object[]{"db.awaitIndex", "db.awaitIndex(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\"))."}), IsEqual.equalTo((Object)new Object[]{"db.awaitIndexes", "db.awaitIndexes(timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\"))."}), IsEqual.equalTo((Object)new Object[]{"db.resampleIndex", "db.resampleIndex(index :: STRING?) :: VOID", "Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\"))."}), IsEqual.equalTo((Object)new Object[]{"db.resampleOutdatedIndexes", "db.resampleOutdatedIndexes() :: VOID", "Schedule resampling of all outdated indexes."}), IsEqual.equalTo((Object)new Object[]{"db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)", "List all property keys in the database."}), IsEqual.equalTo((Object)new Object[]{"db.labels", "db.labels() :: (label :: STRING?)", "List all labels in the database."}), IsEqual.equalTo((Object)new Object[]{"db.schema", "db.schema() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Show the schema of the data."}), IsEqual.equalTo((Object)new Object[]{"db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)", "List all relationship types in the database."}), IsEqual.equalTo((Object)new Object[]{"dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all procedures in the DBMS."}), IsEqual.equalTo((Object)new Object[]{"dbms.functions", "dbms.functions() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all user functions in the DBMS."}), IsEqual.equalTo((Object)new Object[]{"dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)", "List DBMS components and their versions."}), IsEqual.equalTo((Object)new Object[]{"dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)", "Query JMX management data by domain and name. For instance, \"org.neo4j:*\""}), IsEqual.equalTo((Object)new Object[]{"db.createLabel", "db.createLabel(newLabel :: STRING?) :: VOID", "Create a label"}), IsEqual.equalTo((Object)new Object[]{"db.createProperty", "db.createProperty(newProperty :: STRING?) :: VOID", "Create a Property"}), IsEqual.equalTo((Object)new Object[]{"db.createRelationshipType", "db.createRelationshipType(newRelationshipType :: STRING?) :: VOID", "Create a RelationshipType"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.searchNodes", "db.index.explicit.searchNodes(indexName :: STRING?, query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit index. Replaces `START n=node:nodes('key:foo*')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.seekNodes", "db.index.explicit.seekNodes(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit index. Replaces `START n=node:nodes(key = 'A')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.searchRelationships", "db.index.explicit.searchRelationships(indexName :: STRING?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index. Replaces `START r=relationship:relIndex('key:foo*')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.auto.searchNodes", "db.index.explicit.auto.searchNodes(query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit automatic index. Replaces `START n=node:node_auto_index('key:foo*')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.auto.seekNodes", "db.index.explicit.auto.seekNodes(key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit automatic index. Replaces `START n=node:node_auto_index(key = 'A')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.auto.searchRelationships", "db.index.explicit.auto.searchRelationships(query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit automatic index. Replaces `START r=relationship:relationship_auto_index('key:foo*')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.auto.seekRelationships", "db.index.explicit.auto.seekRelationships(key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit automatic index. Replaces `START r=relationship:relationship_auto_index(key = 'A')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.addNode", "db.index.explicit.addNode(indexName :: STRING?, node :: NODE?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a node to an explicit index based on a specified key and value"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.addRelationship", "db.index.explicit.addRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a relationship to an explicit index based on a specified key and value"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.removeNode", "db.index.explicit.removeNode(indexName :: STRING?, node :: NODE?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a node from an explicit index with an optional key"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.removeRelationship", "db.index.explicit.removeRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a relationship from an explicit index with an optional key"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.drop", "db.index.explicit.drop(indexName :: STRING?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Remove an explicit index - YIELD type,name,config"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.forNodes", "db.index.explicit.forNodes(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a node explicit index - YIELD type,name,config"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.forRelationships", "db.index.explicit.forRelationships(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a relationship explicit index - YIELD type,name,config"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.existsForNodes", "db.index.explicit.existsForNodes(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a node explicit index exists"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.existsForRelationships", "db.index.explicit.existsForRelationships(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a relationship explicit index exists"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.list", "db.index.explicit.list() :: (type :: STRING?, name :: STRING?, config :: MAP?)", "List all explicit indexes - YIELD type,name,config"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.seekRelationships", "db.index.explicit.seekRelationships(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit index. Replaces `START r=relationship:relIndex(key = 'A')`"}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.searchRelationshipsBetween", "db.index.explicit.searchRelationshipsBetween(indexName :: STRING?, in :: NODE?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in' and ending at 'out'."}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.searchRelationshipsIn", "db.index.explicit.searchRelationshipsIn(indexName :: STRING?, in :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in'."}), IsEqual.equalTo((Object)new Object[]{"db.index.explicit.searchRelationshipsOut", "db.index.explicit.searchRelationshipsOut(indexName :: STRING?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, ending at the node 'out'."})}));
        this.commit();
    }

    @Test
    public void failWhenCallingNonExistingProcedures() throws Throwable {
        try {
            this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "iDoNotExist"}), new Object[0], (SecurityContext)AnonymousContext.none(), this.resourceTracker);
            TestCase.fail((String)"This should never get here");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listAllComponents() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"Neo4j Kernel", Collections.singletonList(Version.getNeo4jVersion()), "community"})));
        this.commit();
    }

    @Test
    public void listAllIndexes() throws Throwable {
        Statement statement = this.statementInNewTransaction(SecurityContext.AUTH_DISABLED);
        int labelId1 = statement.tokenWriteOperations().labelGetOrCreateForName("Person");
        int labelId2 = statement.tokenWriteOperations().labelGetOrCreateForName("Age");
        int propertyKeyId1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("bar");
        statement.schemaWriteOperations().indexCreate(SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1}));
        statement.schemaWriteOperations().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1}));
        statement.schemaWriteOperations().indexCreate(SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2}));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.success();
        }
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"}), new Object[0]);
        HashSet<Object> result = new HashSet<Object>();
        while (stream.hasNext()) {
            result.add(stream.next());
        }
        Map providerDescriptionMap = MapUtil.stringMap((String[])new String[]{"key", "in-memory-index", "version", "1.0"});
        MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[][]{{"INDEX ON :Age(foo)", "Age", Collections.singletonList("foo"), "ONLINE", "node_unique_property", providerDescriptionMap}, {"INDEX ON :Person(foo)", "Person", Collections.singletonList("foo"), "ONLINE", "node_label_property", providerDescriptionMap}, {"INDEX ON :Person(foo, bar)", "Person", Arrays.asList("foo", "bar"), "ONLINE", "node_label_property", providerDescriptionMap}}));
        this.commit();
    }
}

