/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ProcedureCallOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public abstract class KernelIntegrationTest {
    protected final TestDirectory testDir = TestDirectory.testDirectory();
    protected final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule);
    protected GraphDatabaseAPI db;
    ThreadToStatementContextBridge statementContextSupplier;
    protected KernelAPI kernel;
    protected IndexingService indexingService;
    private KernelTransaction transaction;
    private Statement statement;
    private DbmsOperations dbmsOperations;

    protected Statement statementInNewTransaction(SecurityContext securityContext) throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, securityContext);
        this.statement = this.transaction.acquireStatement();
        return this.statement;
    }

    protected TokenWriteOperations tokenWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.writeToken());
        this.statement = this.transaction.acquireStatement();
        return this.statement.tokenWriteOperations();
    }

    protected DataWriteOperations dataWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.write());
        this.statement = this.transaction.acquireStatement();
        return this.statement.dataWriteOperations();
    }

    protected SchemaWriteOperations schemaWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        this.statement = this.transaction.acquireStatement();
        return this.statement.schemaWriteOperations();
    }

    protected ProcedureCallOperations procedureCallOpsInNewTx() throws TransactionFailureException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());
        this.statement = this.transaction.acquireStatement();
        return this.statement.procedureCallOperations();
    }

    protected ReadOperations readOperationsInNewTransaction() throws TransactionFailureException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());
        this.statement = this.transaction.acquireStatement();
        return this.statement.readOperations();
    }

    protected DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    protected void commit() throws TransactionFailureException {
        this.statement.close();
        this.statement = null;
        this.transaction.success();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    protected void rollback() throws TransactionFailureException {
        this.statement.close();
        this.statement = null;
        this.transaction.failure();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    @Before
    public void setup() {
        this.startDb();
    }

    @After
    public void cleanup() throws Exception {
        this.stopDb();
    }

    protected void startDb() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase();
        this.kernel = (KernelAPI)this.db.getDependencyResolver().resolveDependency(KernelAPI.class);
        this.indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        this.statementContextSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.dbmsOperations = (DbmsOperations)this.db.getDependencyResolver().resolveDependency(DbmsOperations.class);
    }

    protected GraphDatabaseService createGraphDatabase() {
        GraphDatabaseBuilder graphDatabaseBuilder = new TestGraphDatabaseFactory().setFileSystem(this.fileSystemRule.get()).newEmbeddedDatabaseBuilder(this.testDir.graphDbDir());
        return this.configure(graphDatabaseBuilder).newGraphDatabase();
    }

    protected GraphDatabaseBuilder configure(GraphDatabaseBuilder graphDatabaseBuilder) {
        return graphDatabaseBuilder;
    }

    void dbWithNoCache() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    private void stopDb() throws TransactionFailureException {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.db.shutdown();
    }

    protected void restartDb() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }
}

