/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.Token;

public class LabelIT
extends KernelIntegrationTest {
    @Test
    public void shouldListAllLabels() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int label1Id = statement.tokenWriteOperations().labelGetOrCreateForName("label1");
        int label2Id = statement.tokenWriteOperations().labelGetOrCreateForName("label2");
        Iterator labelIdsBeforeCommit = statement.readOperations().labelsGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)labelIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("label1", label1Id), new Token("label2", label2Id)}));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Iterator labelIdsAfterCommit = readOperations.labelsGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)labelIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("label1", label1Id), new Token("label2", label2Id)}));
        this.commit();
    }

    @Test
    public void addingAndRemovingLabelInSameTxShouldHaveNoEffect() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int label = statement.tokenWriteOperations().labelGetOrCreateForName("Label 1");
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeAddLabel(node, label);
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeRemoveLabel(node, label);
        dataWriteOperations.nodeAddLabel(node, label);
        this.commit();
        Assert.assertTrue((boolean)this.readOperationsInNewTransaction().nodeHasLabel(node, label));
        this.commit();
    }
}

