/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.DoubleLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeGetUniqueFromIndexSeekIT
extends KernelIntegrationTest {
    private int labelId;
    private int propertyId1;
    private int propertyId2;

    @Before
    public void createKeys() throws Exception {
        TokenWriteOperations tokenWriteOperations = this.tokenWriteOperationsInNewTransaction();
        this.labelId = tokenWriteOperations.labelGetOrCreateForName("Person");
        this.propertyId1 = tokenWriteOperations.propertyKeyGetOrCreateForName("foo");
        this.propertyId2 = tokenWriteOperations.propertyKeyGetOrCreateForName("bar");
        this.commit();
    }

    @Test
    public void shouldFindMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        long nodeId = this.createNodeWithValue(value);
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        int propertyId = index.schema().getPropertyId();
        long foundId = readOperations.nodeGetFromUniqueIndexSeek(index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propertyId, (Object)value)});
        this.commit();
        Assert.assertTrue((String)"Created node was not found", (nodeId == foundId ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotFindNonMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        this.createNodeWithValue(Values.of((Object)("other_" + value)));
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        long foundId = readOperations.nodeGetFromUniqueIndexSeek(index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value)});
        this.commit();
        Assert.assertTrue((String)"Non-matching created node was found", (boolean)this.isNoSuchNode(foundId));
    }

    @Test
    public void shouldCompositeFindMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        long nodeId = this.createNodeWithValues(value1, value2);
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        long foundId = readOperations.nodeGetFromUniqueIndexSeek(index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value1), IndexQuery.exact((int)this.propertyId2, (Object)value2)});
        this.commit();
        Assert.assertTrue((String)"Created node was not found", (nodeId == foundId ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotCompositeFindNonMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        this.createNodeWithValues(Values.of((Object)("other_" + value1)), Values.of((Object)("other_" + value2)));
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        long foundId = readOperations.nodeGetFromUniqueIndexSeek(index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value1), IndexQuery.exact((int)this.propertyId2, (Object)value2)});
        this.commit();
        Assert.assertTrue((String)"Non-matching created node was found", (boolean)this.isNoSuchNode(foundId));
    }

    @Test(timeout=10000L)
    public void shouldBlockUniqueIndexSeekFromCompetingTransaction() throws Exception {
        DoubleLatch latch = new DoubleLatch();
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        long nodeId = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(nodeId, this.labelId);
        dataStatement.nodeSetProperty(nodeId, this.propertyId1, value);
        Runnable runnableForThread2 = () -> {
            latch.waitForAllToStart();
            try (Transaction tx = this.db.beginTx();){
                try (Statement statement1 = this.statementContextSupplier.get();){
                    statement1.readOperations().nodeGetFromUniqueIndexSeek(index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value)});
                }
                tx.success();
            }
            catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
                throw new RuntimeException(e);
            }
            finally {
                latch.finish();
            }
        };
        Thread thread2 = new Thread(runnableForThread2, "Transaction Thread 2");
        thread2.start();
        latch.startAndWaitForAllToStart();
        while (thread2.getState() != Thread.State.TIMED_WAITING && thread2.getState() != Thread.State.WAITING) {
            Thread.yield();
        }
        this.commit();
        latch.waitForAllToFinish();
    }

    private boolean isNoSuchNode(long foundId) {
        return -1L == foundId;
    }

    private long createNodeWithValue(Value value) throws KernelException {
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        long nodeId = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(nodeId, this.labelId);
        dataStatement.nodeSetProperty(nodeId, this.propertyId1, value);
        this.commit();
        return nodeId;
    }

    private long createNodeWithValues(Value value1, Value value2) throws KernelException {
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        long nodeId = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(nodeId, this.labelId);
        dataStatement.nodeSetProperty(nodeId, this.propertyId1, value1);
        dataStatement.nodeSetProperty(nodeId, this.propertyId2, value2);
        this.commit();
        return nodeId;
    }

    private IndexDescriptor createUniquenessConstraint(int labelId, int ... propertyIds) throws Exception {
        Statement statement = this.statementInNewTransaction(SecurityContext.AUTH_DISABLED);
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds);
        statement.schemaWriteOperations().uniquePropertyConstraintCreate(descriptor);
        IndexDescriptor result = statement.readOperations().indexGetForSchema(descriptor);
        this.commit();
        return result;
    }
}

