/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.Token;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyIT
extends KernelIntegrationTest {
    @Test
    public void shouldBeAbleToSetAndReadLargeByteArray() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, Values.of((Object)new byte[100000]));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        readOperations.nodeGetProperty(nodeId, propertyKeyId);
        this.commit();
    }

    @Test
    public void shouldSetNodePropertyValue() throws Exception {
        Value value = Values.of((Object)"bozo");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, value);
        Assert.assertEquals((Object)value, (Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)value, (Object)readOperations.nodeGetProperty(nodeId, propertyKeyId));
        this.commit();
    }

    @Test
    public void shouldRemoveSetNodeProperty() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, (Value)Values.stringValue((String)"bozo"));
        statement.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId);
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }

    @Test
    public void shouldRemoveSetNodePropertyAcrossTransactions() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, (Value)Values.stringValue((String)"bozo"));
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        Value previous = statement.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId);
        Assert.assertTrue((boolean)previous.equals("bozo"));
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }

    @Test
    public void shouldRemoveSetExistingProperty() throws Exception {
        this.dbWithNoCache();
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, (Value)Values.stringValue((String)"bozo"));
        this.commit();
        TextValue newValue = Values.stringValue((String)"ozob");
        Statement statement2 = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        statement2.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId);
        statement2.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, (Value)newValue);
        Assert.assertThat((Object)statement2.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newValue));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newValue));
        Assert.assertThat((Object)PrimitiveIntCollections.toList((PrimitiveIntIterator)readOperations.nodeGetPropertyKeys(nodeId)), (Matcher)CoreMatchers.equalTo(Collections.singletonList(propertyKeyId)));
        this.commit();
    }

    @Test
    public void shouldSilentlyNotRemoveMissingNodeProperty() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Value result = statement.nodeRemoveProperty(nodeId, propertyId);
        Assert.assertTrue((String)"Return no property if removing missing", (result == Values.NO_VALUE ? 1 : 0) != 0);
        this.commit();
    }

    @Test
    public void nodeHasPropertyIfSet() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyKeyId, (Value)Values.stringValue((String)"bozo"));
        Assert.assertThat((Object)statement.readOperations().nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE)));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE)));
        this.commit();
    }

    @Test
    public void nodeHasNotPropertyIfUnset() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        Assert.assertThat((Object)statement.readOperations().nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }

    @Test
    public void shouldRollbackSetNodePropertyValue() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeSetProperty(nodeId, propertyKeyId, (Value)Values.stringValue((String)"bozo"));
        this.rollback();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }

    @Test
    public void shouldUpdateNodePropertyValue() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, propertyId, (Value)Values.stringValue((String)"bozo"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeSetProperty(nodeId, propertyId, Values.of((Object)42));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)42, (Object)readOperations.nodeGetProperty(nodeId, propertyId).asObject());
        this.commit();
    }

    @Test
    public void shouldListAllPropertyKeys() throws Exception {
        this.dbWithNoCache();
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        int prop2 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop2");
        Iterator propIdsBeforeCommit = statement.readOperations().propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", prop1), new Token("prop2", prop2)}));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Iterator propIdsAfterCommit = readOperations.propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", prop1), new Token("prop2", prop2)}));
        this.commit();
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedNode() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeSetProperty(node, prop1, (Value)Values.stringValue((String)"As"));
        statement.dataWriteOperations().nodeDelete(node);
        try {
            statement.dataWriteOperations().nodeRemoveProperty(node, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load NODE with id " + node + ".")));
        }
        this.commit();
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedRelationship() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        int type = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        long rel = statement.dataWriteOperations().relationshipCreate(type, startNodeId, endNodeId);
        statement.dataWriteOperations().relationshipSetProperty(rel, prop1, (Value)Values.stringValue((String)"As"));
        statement.dataWriteOperations().relationshipDelete(rel);
        try {
            statement.dataWriteOperations().relationshipRemoveProperty(rel, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load RELATIONSHIP with id " + rel + ".")));
        }
        this.commit();
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnNode() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeSetProperty(node, prop, Values.of((Object)"bar"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeRemoveProperty(node, prop);
        dataWriteOperations.nodeSetProperty(node, prop, Values.of((Object)"bar"));
        dataWriteOperations.nodeRemoveProperty(node, prop);
        dataWriteOperations.nodeRemoveProperty(node, prop);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(node, prop), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnRelationship() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        int type = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        long rel = statement.dataWriteOperations().relationshipCreate(type, startNodeId, endNodeId);
        statement.dataWriteOperations().relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        dataWriteOperations.relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.relationshipGetProperty(rel, prop), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }
}

