/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class RelationshipIT
extends KernelIntegrationTest {
    @Rule
    public OtherThreadRule<Object> otherThread = new OtherThreadRule(10L, TimeUnit.SECONDS);

    @Test
    public void shouldListRelationshipsInCurrentAndSubsequentTx() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relType1 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.dataWriteOperations().nodeCreate();
        long otherNode = statement.dataWriteOperations().nodeCreate();
        long fromRefToOther1 = statement.dataWriteOperations().relationshipCreate(relType1, refNode, otherNode);
        long fromRefToOther2 = statement.dataWriteOperations().relationshipCreate(relType2, refNode, otherNode);
        long fromOtherToRef = statement.dataWriteOperations().relationshipCreate(relType1, otherNode, refNode);
        long fromRefToRef = statement.dataWriteOperations().relationshipCreate(relType2, refNode, refNode);
        long endNode = statement.dataWriteOperations().nodeCreate();
        long fromRefToThird = statement.dataWriteOperations().relationshipCreate(relType2, refNode, endNode);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels((PrimitiveLongIterator)readOperations.nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
    }

    @Test
    public void shouldInterleaveModifiedRelationshipsWithExistingOnes() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relType1 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.dataWriteOperations().nodeCreate();
        long otherNode = statement.dataWriteOperations().nodeCreate();
        long fromRefToOther1 = statement.dataWriteOperations().relationshipCreate(relType1, refNode, otherNode);
        long fromRefToOther2 = statement.dataWriteOperations().relationshipCreate(relType2, refNode, otherNode);
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        statement.dataWriteOperations().relationshipDelete(fromRefToOther1);
        long endNode = statement.dataWriteOperations().nodeCreate();
        long localTxRel = statement.dataWriteOperations().relationshipCreate(relType1, refNode, endNode);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther2, localTxRel);
        this.assertRelsInSeparateTx(refNode, Direction.BOTH, fromRefToOther1, fromRefToOther2);
        this.commit();
    }

    @Test
    public void shouldReturnRelsWhenAskingForRelsWhereOnlySomeTypesExistInCurrentRel() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relType1 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.dataWriteOperations().nodeCreate();
        long otherNode = statement.dataWriteOperations().nodeCreate();
        long theRel = statement.dataWriteOperations().relationshipCreate(relType1, refNode, otherNode);
        this.assertRels((PrimitiveLongIterator)statement.readOperations().nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType2, relType1}), theRel);
        this.commit();
    }

    @Test
    public void askingForNonExistantReltypeOnDenseNodeShouldNotCorruptState() throws Exception {
        long[] rels = new long[200];
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int relTypeTheNodeDoesUse = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type1");
        int relTypeTheNodeDoesNotUse = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.dataWriteOperations().nodeCreate();
        long otherNode = statement.dataWriteOperations().nodeCreate();
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = statement.dataWriteOperations().relationshipCreate(relTypeTheNodeDoesUse, refNode, otherNode);
        }
        this.commit();
        ReadOperations stmt = this.readOperationsInNewTransaction();
        this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relTypeTheNodeDoesNotUse}), new long[0]);
        this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relTypeTheNodeDoesUse}), rels);
        this.commit();
    }

    private void assertRelsInSeparateTx(long refNode, Direction both, long ... longs) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.assertTrue((boolean)((Boolean)this.otherThread.execute(state -> {
            try (Transaction tx = this.db.beginTx();
                 Statement statement = this.statementContextSupplier.get();){
                ReadOperations stmt = statement.readOperations();
                this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, both), longs);
            }
            return true;
        }).get(10L, TimeUnit.SECONDS)));
    }

    private void assertRels(PrimitiveLongIterator it, long ... rels) {
        ArrayList<Matcher> all = new ArrayList<Matcher>(rels.length);
        for (long element : rels) {
            all.add(CoreMatchers.hasItem((Object)element));
        }
        List list = PrimitiveLongCollections.asList((PrimitiveLongIterator)it);
        Assert.assertThat((Object)list, (Matcher)AllOf.allOf(all));
    }
}

