/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.operations;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConstraintEnforcingEntityOperationsTest {
    private final int labelId = 1;
    private final int propertyKeyId = 2;
    private final Value value = Values.of((Object)"value");
    private final long resourceId = ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)2, (Object)this.value)});
    private final IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{2});
    private final IndexQuery.ExactPredicate withValue = IndexQuery.exact((int)2, (Object)this.value);
    private EntityReadOperations readOps;
    private KernelStatement state;
    private Locks.Client locks;
    private ConstraintEnforcingEntityOperations ops;
    private SchemaReadOperations schemaReadOps;
    private EntityWriteOperations entityWriteOperations;

    @Before
    public void given_ConstraintEnforcingEntityOperations_with_OnlineIndex() throws Exception {
        this.readOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        this.schemaReadOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.entityWriteOperations = (EntityWriteOperations)Mockito.mock(EntityWriteOperations.class);
        SchemaWriteOperations schemaWriteOps = (SchemaWriteOperations)Mockito.mock(SchemaWriteOperations.class);
        this.state = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)this.schemaReadOps.indexGetState(this.state, this.index)).thenReturn((Object)InternalIndexState.ONLINE);
        this.locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)this.state.locks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        Mockito.when((Object)this.state.lockTracer()).thenReturn((Object)LockTracer.NONE);
        this.ops = new ConstraintEnforcingEntityOperations((ConstraintSemantics)new StandardConstraintSemantics(), this.entityWriteOperations, this.readOps, schemaWriteOps, this.schemaReadOps);
    }

    @Test
    public void shouldHoldIndexReadLockIfNodeIsExists() throws Exception {
        long expectedNodeId = 15L;
        Mockito.when((Object)this.readOps.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue})).thenReturn((Object)expectedNodeId);
        long nodeId = this.ops.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue});
        Assert.assertEquals((long)expectedNodeId, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    public void acquireAllLabelsSharedLocksBeforeSettingPropertyOnNode() throws Exception {
        Cursor<NodeItem> nodeCursor = StubCursors.asNodeCursor(123L, PrimitiveIntCollections.asSet((int[])new int[]{1, 5, 7}));
        nodeCursor.next();
        Mockito.when((Object)this.readOps.nodeCursorById(this.state, 123L)).thenReturn(nodeCursor);
        Mockito.when((Object)this.schemaReadOps.constraintsGetAll(this.state)).thenReturn(Collections.emptyIterator());
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.ops.nodeSetProperty(this.state, 123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{1L, 5L, 7L});
        ((EntityWriteOperations)Mockito.verify((Object)this.entityWriteOperations)).nodeSetProperty(this.state, 123L, propertyKeyId, value);
    }

    @Test
    public void shouldHoldIndexWriteLockIfNodeDoesNotExist() throws Exception {
        Mockito.when((Object)this.readOps.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue})).thenReturn((Object)-1L);
        long nodeId = this.ops.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue});
        Assert.assertEquals((long)-1L, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseShared((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    public void shouldHoldIndexReadLockIfNodeIsConcurrentlyCreated() throws Exception {
        long expectedNodeId = 15L;
        Mockito.when((Object)this.readOps.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue})).thenReturn((Object)-1L).thenReturn((Object)expectedNodeId);
        long nodeId = this.ops.nodeGetFromUniqueIndexSeek(this.state, this.index, new IndexQuery.ExactPredicate[]{this.withValue});
        Assert.assertEquals((long)expectedNodeId, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseShared((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{this.resourceId});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }
}

