/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.schema.NodeSchemaMatcher;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.values.storable.Values;

public class NodeSchemaMatcherTest {
    private static final int labelId1 = 10;
    private static final int labelId2 = 11;
    private static final int nonExistentLabelId = 12;
    private static final int propId1 = 20;
    private static final int propId2 = 21;
    private static final int unIndexedPropId = 22;
    private static final int nonExistentPropId = 23;
    private static final int specialPropId = 24;
    KernelStatement state;
    NodeItem node;
    IndexDescriptor index1 = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20});
    IndexDescriptor index1_2 = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20, 21});
    IndexDescriptor indexWithMissingProperty = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20, 23});
    IndexDescriptor indexWithMissingLabel = IndexDescriptorFactory.forLabel((int)12, (int[])new int[]{20, 21});
    IndexDescriptor indexOnSpecialProperty = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{20, 24});
    private NodeSchemaMatcher nodeSchemaMatcher;

    @Before
    public void setup() {
        this.state = (KernelStatement)Mockito.mock(KernelStatement.class);
        PrimitiveIntSet labels = Primitive.intSet();
        labels.add(10);
        Cursor<NodeItem> nodeItemCursor = StubCursors.asNodeCursor(0L, labels);
        nodeItemCursor.next();
        this.node = (NodeItem)nodeItemCursor.get();
        PrimitiveIntSet defaultPropertyIds = PrimitiveIntCollections.asSet((int[])new int[]{20, 21, 22});
        EntityReadOperations readOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        Mockito.when((Object)readOps.nodeGetPropertyKeys(this.state, this.node)).thenReturn((Object)defaultPropertyIds);
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 20)).thenReturn((Object)Values.of((Object)"hi1"));
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 21)).thenReturn((Object)Values.of((Object)"hi2"));
        Mockito.when((Object)readOps.nodeGetProperty(this.state, this.node, 22)).thenReturn((Object)Values.of((Object)"hi3"));
        this.nodeSchemaMatcher = new NodeSchemaMatcher(readOps);
    }

    @Test
    public void shouldMatchOnSingleProperty() {
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, Iterators.iterator((Object)this.index1), this.node, 22, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.index1}));
    }

    @Test
    public void shouldMatchOnTwoProperties() {
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, Iterators.iterator((Object)this.index1_2), this.node, 22, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.index1_2}));
    }

    @Test
    public void shouldNotMatchIfNodeIsMissingProperty() {
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, Iterators.iterator((Object)this.indexWithMissingProperty), this.node, 22, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotMatchIfNodeIsMissingLabel() {
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, Iterators.iterator((Object)this.indexWithMissingLabel), this.node, 22, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldMatchOnSpecialProperty() {
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, Iterators.iterator((Object)this.indexOnSpecialProperty), this.node, 24, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.contains((Object[])new IndexDescriptor[]{this.indexOnSpecialProperty}));
    }

    @Test
    public void shouldMatchSeveralTimes() {
        List<IndexDescriptor> indexes = Arrays.asList(this.index1, this.index1, this.index1_2, this.index1_2);
        ArrayList matched = new ArrayList();
        this.nodeSchemaMatcher.onMatchingSchema(this.state, indexes.iterator(), this.node, 22, (schema, props) -> matched.add(schema));
        MatcherAssert.assertThat(matched, (Matcher)Matchers.equalTo(indexes));
    }
}

