/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.explicitindex.AutoIndexOperations;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreStatement;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class StateHandlingStatementOperationsTest {
    StoreReadLayer inner = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)10, (int[])new int[]{66});
    private final IndexDescriptor index = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});

    @Test
    public void shouldNeverDelegateWrites() throws Exception {
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        Mockito.when((Object)state.txState()).thenReturn((Object)new TxState());
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)state.getStoreStatement()).thenReturn((Object)storeStatement);
        Mockito.when((Object)this.inner.indexesGetForLabel(0)).thenReturn((Object)Iterators.iterator((Object)IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0})));
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenReturn(StubCursors.asNodeCursor(0L));
        Mockito.when((Object)this.inner.nodeGetProperties((StorageStatement)Matchers.eq((Object)storeStatement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue[0]));
        StateHandlingStatementOperations ctx = this.newTxStateOps(this.inner);
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        ctx.indexCreate(state, descriptor);
        ctx.nodeAddLabel(state, 0L, 0);
        ctx.indexDrop(state, IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)descriptor));
        ctx.nodeRemoveLabel(state, 0L, 0);
        ((StoreStatement)Mockito.verify((Object)storeStatement, (VerificationMode)Mockito.times((int)2))).acquireSingleNodeCursor(0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{storeStatement});
    }

    @Test
    public void shouldNotAddConstraintAlreadyExistsInTheStore() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor);
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)txState.nodesWithLabelChanged(Matchers.anyInt())).thenReturn((Object)new DiffSets());
        Mockito.when((Object)txState.hasChanges()).thenReturn((Object)true);
        KernelStatement state = StatementOperationsTestHelper.mockedState(txState);
        Mockito.when((Object)this.inner.constraintsGetForSchema((SchemaDescriptor)Matchers.any())).thenReturn((Object)Iterators.iterator((Object)constraint));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, this.descriptor);
        ((TransactionState)Mockito.verify((Object)txState)).indexDoUnRemove((IndexDescriptor)Matchers.eq((Object)constraint.ownedIndexDescriptor()));
    }

    @Test
    public void shouldGetConstraintsByLabelAndProperty() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForSchema(constraint.schema())).thenAnswer(invocation -> Collections.emptyIterator());
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, this.descriptor);
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetForSchema(state, constraint.schema())));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint}), (Object)result);
    }

    @Test
    public void shouldGetConstraintsByLabel() throws Exception {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{3});
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)4, (int[])new int[]{5});
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForSchema((SchemaDescriptor)constraint1.schema())).thenAnswer(invocation -> Collections.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForSchema((SchemaDescriptor)constraint2.schema())).thenAnswer(invocation -> Collections.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabel(1)).thenAnswer(invocation -> Collections.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabel(2)).thenAnswer(invocation -> Iterators.iterator((Object)constraint1));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, constraint1.ownedIndexDescriptor().schema());
        context.uniquePropertyConstraintCreate(state, constraint2.ownedIndexDescriptor().schema());
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetForLabel(state, 2)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new UniquenessConstraintDescriptor[]{constraint1}), (Object)result);
    }

    @Test
    public void shouldGetAllConstraints() throws Exception {
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{3});
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)4, (int[])new int[]{5});
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForSchema((SchemaDescriptor)constraint1.schema())).thenAnswer(invocation -> Collections.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForSchema((SchemaDescriptor)constraint2.schema())).thenAnswer(invocation -> Collections.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetAll()).thenAnswer(invocation -> Iterators.iterator((Object)constraint2));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, constraint1.schema());
        context.uniquePropertyConstraintCreate(state, constraint2.schema());
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetAll(state)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new UniquenessConstraintDescriptor[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexScanWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForScan(this.index)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.ExistsPredicate query = IndexQuery.exists((int)this.index.schema().getPropertyId());
        Mockito.when((Object)indexReader.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{query});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexSeekWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForSeek(this.index, ValueTuple.of((Object[])new Object[]{"value"}))).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.ExactPredicate query = IndexQuery.exact((int)this.index.schema().getPropertyId(), (Object)"value");
        Mockito.when((Object)indexReader.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{query});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekByPrefix() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByPrefix(this.index, "prefix")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.StringPrefixPredicate query = IndexQuery.stringPrefix((int)this.index.schema().getPropertyId(), (String)"prefix");
        Mockito.when((Object)indexReader.query(new IndexQuery[]{query})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{query});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekByPrefixWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByPrefix(this.index, "prefix")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.StringPrefixPredicate indexQuery = IndexQuery.stringPrefix((int)this.index.schema().getPropertyId(), (String)"prefix");
        Mockito.when((Object)indexReader.query(new IndexQuery[]{indexQuery})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{indexQuery});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekByContainsWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForScan(this.index)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.StringContainsPredicate indexQuery = IndexQuery.stringContains((int)this.index.schema().getPropertyId(), (String)"contains");
        Mockito.when((Object)indexReader.query(new IndexQuery[]{indexQuery})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{indexQuery});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekBySuffixWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForScan(this.index)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.StringSuffixPredicate indexQuery = IndexQuery.stringSuffix((int)this.index.schema().getPropertyId(), (String)"suffix");
        Mockito.when((Object)indexReader.query(new IndexQuery[]{indexQuery})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{indexQuery});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByNumberWithIndexQuery() throws Exception {
        int propertyKey = 2;
        int inRange = 15;
        int lower = 10;
        int upper = 20;
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)statement.getStoreStatement()).thenReturn((Object)storageStatement);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByNumber(this.index, (Number)lower, true, (Number)upper, false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)txState.augmentSingleNodeCursor((Cursor)Matchers.any(Cursor.class), Matchers.anyLong())).thenAnswer(invocationOnMock -> {
            long nodeId = (Long)invocationOnMock.getArguments()[1];
            Mockito.when((Object)txState.augmentSinglePropertyCursor((Cursor)Matchers.any(Cursor.class), (PropertyContainerState)Matchers.any(PropertyContainerState.class), Matchers.eq((int)2))).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(2, Values.of((Object)15))));
            return StubCursors.asNodeCursor(nodeId, nodeId + 20000L);
        });
        IndexReader indexReader = this.addMockedIndexReader(storageStatement);
        IndexQuery.NumberRangePredicate indexQuery = IndexQuery.range((int)this.index.schema().getPropertyId(), (Number)lower, (boolean)true, (Number)upper, (boolean)false);
        Mockito.when((Object)indexReader.query(new IndexQuery[]{indexQuery})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        Mockito.when((Object)storageStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenAnswer(invocationOnMock -> {
            long nodeId = (Long)invocationOnMock.getArguments()[0];
            Mockito.when((Object)storeReadLayer.nodeGetProperty((StorageStatement)Matchers.eq((Object)storageStatement), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)2), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new PropertyKeyValue(2, Values.of((Object)15))));
            return StubCursors.asNodeCursor(nodeId, nodeId + 20000L);
        });
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{indexQuery});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByStringWithIndexQuery() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByString(this.index, "Anne", true, "Bill", false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        IndexQuery.StringRangePredicate rangePredicate = IndexQuery.range((int)this.index.schema().getPropertyId(), (String)"Anne", (boolean)true, (String)"Bill", (boolean)false);
        Mockito.when((Object)indexReader.query(new IndexQuery[]{rangePredicate})).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.indexQuery(statement, this.index, new IndexQuery[]{rangePredicate});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void indexQueryClosesIndexReader() throws Exception {
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)indexReader.query((IndexQuery[])Matchers.any())).thenReturn((Object)PrimitiveLongCollections.emptyIterator());
        Mockito.when((Object)storeStatement.getFreshIndexReader((IndexDescriptor)Matchers.any())).thenReturn((Object)indexReader);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        StateHandlingStatementOperations operations = this.newTxStateOps((StoreReadLayer)Mockito.mock(StoreReadLayer.class));
        operations.nodeGetFromUniqueIndexSeek(kernelStatement, IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1}), new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)"foo")});
        ((IndexReader)Mockito.verify((Object)indexReader)).close();
    }

    @Test
    public void shouldNotRecordNodeSetPropertyOnSameValue() throws Exception {
        int propertyKeyId = 5;
        long nodeId = 0L;
        Value value = Values.of((Object)"The value");
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Cursor<NodeItem> ourNode = this.nodeCursorWithProperty(propertyKeyId);
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(nodeId)).thenReturn(ourNode);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        InternalAutoIndexing autoIndexing = (InternalAutoIndexing)Mockito.mock(InternalAutoIndexing.class);
        AutoIndexOperations autoIndexOps = (AutoIndexOperations)Mockito.mock(AutoIndexOperations.class);
        Mockito.when((Object)autoIndexing.nodes()).thenReturn((Object)autoIndexOps);
        Mockito.when((Object)autoIndexing.relationships()).thenReturn((Object)AutoIndexOperations.UNSUPPORTED);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Cursor<PropertyItem> propertyItemCursor = this.propertyCursor(propertyKeyId, value);
        Mockito.when((Object)storeReadLayer.nodeGetProperty((StorageStatement)Matchers.eq((Object)storeStatement), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(propertyItemCursor);
        StateHandlingStatementOperations operations = this.newTxStateOps(storeReadLayer, (AutoIndexing)autoIndexing);
        Value newValue = Values.of((Object)"The value");
        operations.nodeSetProperty(kernelStatement, nodeId, propertyKeyId, newValue);
        Assert.assertFalse((boolean)kernelStatement.hasTxStateWithChanges());
        ((AutoIndexOperations)Mockito.verify((Object)autoIndexOps)).propertyChanged((DataWriteOperations)Matchers.any(DataWriteOperations.class), Matchers.eq((long)nodeId), Matchers.eq((int)propertyKeyId), (Value)Matchers.eq((Object)value), (Value)Matchers.eq((Object)newValue));
    }

    @Test
    public void shouldNotRecordRelationshipSetPropertyOnSameValue() throws Exception {
        int propertyKeyId = 5;
        long relationshipId = 0L;
        Value value = Values.of((Object)"The value");
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Cursor<RelationshipItem> ourRelationship = this.relationshipCursorWithProperty(propertyKeyId);
        Mockito.when((Object)storeStatement.acquireSingleRelationshipCursor(relationshipId)).thenReturn(ourRelationship);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        InternalAutoIndexing autoIndexing = (InternalAutoIndexing)Mockito.mock(InternalAutoIndexing.class);
        AutoIndexOperations autoIndexOps = (AutoIndexOperations)Mockito.mock(AutoIndexOperations.class);
        Mockito.when((Object)autoIndexing.nodes()).thenReturn((Object)AutoIndexOperations.UNSUPPORTED);
        Mockito.when((Object)autoIndexing.relationships()).thenReturn((Object)autoIndexOps);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Cursor<PropertyItem> propertyItemCursor = this.propertyCursor(propertyKeyId, value);
        Mockito.when((Object)storeReadLayer.relationshipGetProperty((StorageStatement)Matchers.eq((Object)storeStatement), (RelationshipItem)Matchers.any(RelationshipItem.class), Matchers.eq((int)propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(propertyItemCursor);
        StateHandlingStatementOperations operations = this.newTxStateOps(storeReadLayer, (AutoIndexing)autoIndexing);
        Value newValue = Values.of((Object)"The value");
        operations.relationshipSetProperty(kernelStatement, relationshipId, propertyKeyId, newValue);
        Assert.assertFalse((boolean)kernelStatement.hasTxStateWithChanges());
        ((AutoIndexOperations)Mockito.verify((Object)autoIndexOps)).propertyChanged((DataWriteOperations)Matchers.any(DataWriteOperations.class), Matchers.eq((long)relationshipId), Matchers.eq((int)propertyKeyId), (Value)Matchers.eq((Object)newValue), (Value)Matchers.eq((Object)newValue));
    }

    @Test
    public void shouldNotRecordGraphSetPropertyOnSameValue() throws Exception {
        int propertyKeyId = 5;
        Value value = Values.of((Object)"The value");
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        Mockito.when((Object)this.inner.graphGetAllProperties()).thenReturn((Object)Iterators.iterator((Object)new PropertyKeyValue(propertyKeyId, value)));
        StateHandlingStatementOperations operations = this.newTxStateOps(this.inner);
        Value newValue = Values.of((Object)"The value");
        operations.graphSetProperty(kernelStatement, propertyKeyId, newValue);
        Assert.assertFalse((boolean)kernelStatement.hasTxStateWithChanges());
    }

    @Test
    public void shouldNotDecorateNumberQuerResultsWIthLookupFilterIfIndexHasFullNumberPrecision() throws Exception {
        int propertyKeyId = 5;
        long nodeId = 567L;
        AtomicBoolean nodeCursorCalled = new AtomicBoolean();
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(nodeId)).thenAnswer(invocation -> {
            nodeCursorCalled.set(true);
            return null;
        });
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)indexReader.hasFullNumberPrecision((IndexQuery[])Matchers.anyVararg())).thenReturn((Object)true);
        Mockito.when((Object)indexReader.query((IndexQuery[])Matchers.anyVararg())).thenAnswer(invocation -> PrimitiveLongCollections.iterator((long[])new long[]{nodeId}));
        Mockito.when((Object)storeStatement.getFreshIndexReader((IndexDescriptor)Matchers.any())).thenReturn((Object)indexReader);
        Mockito.when((Object)storeStatement.getIndexReader((IndexDescriptor)Matchers.any())).thenReturn((Object)indexReader);
        StateHandlingStatementOperations operations = this.newTxStateOps(this.inner);
        operations.nodeGetFromUniqueIndexSeek(kernelStatement, this.index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propertyKeyId, (Object)12345L)});
        operations.indexQuery(kernelStatement, this.index, new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)12345L)});
        operations.indexQuery(kernelStatement, this.index, new IndexQuery[]{IndexQuery.range((int)propertyKeyId, (Number)Long.MIN_VALUE, (boolean)true, (Number)Long.MAX_VALUE, (boolean)false)});
        Assert.assertFalse((boolean)nodeCursorCalled.get());
    }

    private Cursor<NodeItem> nodeCursorWithProperty(long propertyKeyId) {
        NodeItem item = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)item.nextPropertyId()).thenReturn((Object)propertyKeyId);
        return StubCursors.cursor(item);
    }

    private Cursor<RelationshipItem> relationshipCursorWithProperty(long propertyKeyId) {
        RelationshipItem item = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)item.nextPropertyId()).thenReturn((Object)propertyKeyId);
        return StubCursors.cursor(item);
    }

    private Cursor<PropertyItem> propertyCursor(long propertyKeyId, Value value) {
        PropertyItem propertyItem = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)propertyItem.propertyKeyId()).thenReturn((Object)((int)propertyKeyId));
        Mockito.when((Object)propertyItem.value()).thenReturn((Object)value);
        return StubCursors.cursor(propertyItem);
    }

    private StateHandlingStatementOperations newTxStateOps(StoreReadLayer delegate) {
        return this.newTxStateOps(delegate, (AutoIndexing)Mockito.mock(InternalAutoIndexing.class));
    }

    private StateHandlingStatementOperations newTxStateOps(StoreReadLayer delegate, AutoIndexing autoIndexing) {
        return new StateHandlingStatementOperations(delegate, autoIndexing, (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class));
    }

    private IndexReader addMockedIndexReader(KernelStatement kernelStatement) throws IndexNotFoundKernelException {
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storageStatement);
        return this.addMockedIndexReader(storageStatement);
    }

    private IndexReader addMockedIndexReader(StorageStatement storeStatement) throws IndexNotFoundKernelException {
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)storeStatement.getIndexReader((IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)indexReader);
        return indexReader;
    }
}

