/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexOperations;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class StateOperationsAutoIndexingTest {
    private final InternalAutoIndexOperations nodeOps = (InternalAutoIndexOperations)Mockito.mock(InternalAutoIndexOperations.class);
    private final InternalAutoIndexOperations relOps = (InternalAutoIndexOperations)Mockito.mock(InternalAutoIndexOperations.class);
    private final AutoIndexing idx = (AutoIndexing)Mockito.mock(InternalAutoIndexing.class);
    private final StorageStatement storeStmt = (StorageStatement)Mockito.mock(StorageStatement.class);
    private final DataWriteOperations writeOps = (DataWriteOperations)Mockito.mock(DataWriteOperations.class);
    private final KernelStatement stmt = (KernelStatement)Mockito.mock(KernelStatement.class, (Answer)Mockito.RETURNS_MOCKS);
    private final StoreReadLayer storeLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class, (Answer)Mockito.RETURNS_MOCKS);
    private final StateHandlingStatementOperations context = new StateHandlingStatementOperations(this.storeLayer, this.idx, (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class));

    @Before
    public void setup() throws InvalidTransactionTypeKernelException {
        Mockito.when((Object)this.idx.nodes()).thenReturn((Object)this.nodeOps);
        Mockito.when((Object)this.idx.relationships()).thenReturn((Object)this.relOps);
        Mockito.when((Object)this.stmt.getStoreStatement()).thenReturn((Object)this.storeStmt);
        Mockito.when((Object)this.stmt.dataWriteOperations()).thenReturn((Object)this.writeOps);
    }

    @Test
    public void shouldSignalNodeRemovedToAutoIndex() throws Exception {
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.cursor((NodeItem)Mockito.mock(NodeItem.class)));
        this.context.nodeDelete(this.stmt, 1337L);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).entityRemoved(this.writeOps, 1337L);
    }

    @Test
    public void shouldSignalRelationshipRemovedToAutoIndex() throws Exception {
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(1337L)).thenReturn(StubCursors.cursor((RelationshipItem)Mockito.mock(RelationshipItem.class)));
        this.context.relationshipDelete(this.stmt, 1337L);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).entityRemoved(this.writeOps, 1337L);
    }

    @Test
    public void shouldSignalNodePropertyAddedToAutoIndex() throws Exception {
        int propertyKeyId = 1;
        Value value = Values.of((Object)"Hello!");
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)node.labels()).thenReturn((Object)PrimitiveIntCollections.emptySet());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.cursor(node));
        Mockito.when((Object)this.storeLayer.nodeGetProperty((StorageStatement)Matchers.eq((Object)this.storeStmt), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.cursor(new PropertyItem[0]));
        this.context.nodeSetProperty(this.stmt, 1337L, propertyKeyId, value);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyAdded(this.writeOps, 1337L, propertyKeyId, value);
    }

    @Test
    public void shouldSignalRelationshipPropertyAddedToAutoIndex() throws Exception {
        int propertyKeyId = 1;
        Value value = Values.of((Object)"Hello!");
        RelationshipItem relationship = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(1337L)).thenReturn(StubCursors.cursor(relationship));
        Mockito.when((Object)this.storeLayer.relationshipGetProperty(this.storeStmt, relationship, propertyKeyId, AssertOpen.ALWAYS_OPEN)).thenReturn((Object)Cursors.empty());
        this.context.relationshipSetProperty(this.stmt, 1337L, propertyKeyId, value);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyAdded(this.writeOps, 1337L, propertyKeyId, value);
    }

    @Test
    public void shouldSignalNodePropertyChangedToAutoIndex() throws Exception {
        int propertyKeyId = 1;
        Value value = Values.of((Object)"Hello!");
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)Values.of((Object)"Goodbye!"));
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)node.labels()).thenReturn((Object)PrimitiveIntCollections.emptySet());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.cursor(node));
        Mockito.when((Object)this.storeLayer.nodeGetProperty((StorageStatement)Matchers.eq((Object)this.storeStmt), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.cursor(existingProperty));
        this.context.nodeSetProperty(this.stmt, 1337L, propertyKeyId, value);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyChanged((DataWriteOperations)Matchers.eq((Object)this.writeOps), Matchers.eq((long)1337L), Matchers.eq((int)propertyKeyId), (Value)Matchers.any(Value.class), (Value)Matchers.eq((Object)value));
    }

    @Test
    public void shouldSignalRelationshipPropertyChangedToAutoIndex() throws Exception {
        int propertyKeyId = 1;
        Value value = Values.of((Object)"Hello!");
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)Values.of((Object)"Goodbye!"));
        RelationshipItem relationship = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(1337L)).thenReturn(StubCursors.cursor(relationship));
        Mockito.when((Object)this.storeLayer.relationshipGetProperty(this.storeStmt, relationship, propertyKeyId, (AssertOpen)this.stmt)).thenReturn(StubCursors.cursor(existingProperty));
        this.context.relationshipSetProperty(this.stmt, 1337L, propertyKeyId, value);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyChanged((DataWriteOperations)Matchers.eq((Object)this.writeOps), Matchers.eq((long)1337L), Matchers.eq((int)propertyKeyId), (Value)Matchers.any(Value.class), (Value)Matchers.eq((Object)value));
    }

    @Test
    public void shouldSignalNodePropertyRemovedToAutoIndex() throws Exception {
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)1);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)Values.of((Object)"Goodbye!"));
        int propertyKeyId = existingProperty.propertyKeyId();
        NodeItem node = (NodeItem)Mockito.mock(NodeItem.class);
        Mockito.when((Object)this.storeLayer.nodeGetProperty((StorageStatement)Matchers.eq((Object)this.storeStmt), (NodeItem)Matchers.any(NodeItem.class), Matchers.eq((int)propertyKeyId), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.cursor(existingProperty));
        Mockito.when((Object)node.labels()).thenReturn((Object)PrimitiveIntCollections.emptySet());
        Mockito.when((Object)this.storeStmt.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.cursor(node));
        this.context.nodeRemoveProperty(this.stmt, 1337L, propertyKeyId);
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.nodeOps)).propertyRemoved(this.writeOps, 1337L, propertyKeyId);
    }

    @Test
    public void shouldSignalRelationshipPropertyRemovedToAutoIndex() throws Exception {
        PropertyItem existingProperty = (PropertyItem)Mockito.mock(PropertyItem.class);
        int propertyKeyId = 1;
        Mockito.when((Object)existingProperty.propertyKeyId()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)existingProperty.value()).thenReturn((Object)Values.of((Object)"Goodbye!"));
        RelationshipItem relationship = (RelationshipItem)Mockito.mock(RelationshipItem.class);
        Mockito.when((Object)this.storeStmt.acquireSingleRelationshipCursor(1337L)).thenReturn(StubCursors.cursor(relationship));
        Mockito.when((Object)this.storeLayer.relationshipGetProperty(this.storeStmt, relationship, propertyKeyId, (AssertOpen)this.stmt)).thenReturn(StubCursors.cursor(existingProperty));
        this.context.relationshipRemoveProperty(this.stmt, 1337L, existingProperty.propertyKeyId());
        ((InternalAutoIndexOperations)Mockito.verify((Object)this.relOps)).propertyRemoved(this.writeOps, 1337L, existingProperty.propertyKeyId());
    }
}

