/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.values.storable.ValueTuple;

public class TxStateCompositeIndexTest {
    private TransactionState state;
    private final IndexDescriptor indexOn_1_1_2 = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2});
    private final IndexDescriptor indexOn_1_2_3 = IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2, 3});
    private final IndexDescriptor indexOn_2_2_3 = IndexDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{2, 3});
    private final IndexDescriptor indexOn_2_2_3_4 = IndexDescriptorFactory.forLabel((int)2, (int[])new int[]{2, 3, 4});

    @Before
    public void before() throws Exception {
        this.state = new TxState();
    }

    @Test
    public void shouldScanOnAnEmptyTxState() throws Exception {
        ReadableDiffSets diffSets = this.state.indexUpdatesForScan(this.indexOn_1_1_2);
        Assert.assertTrue((boolean)diffSets.isEmpty());
    }

    @Test
    public void shouldSeekOnAnEmptyTxState() throws Exception {
        ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(this.indexOn_1_1_2, ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
        Assert.assertTrue((boolean)diffSets.isEmpty());
    }

    @Test
    public void shouldScanWhenThereAreNewNodes() throws Exception {
        this.modifyIndex(this.indexOn_1_1_2).addDefaultStringEntries(42L, 43L);
        this.modifyIndex(this.indexOn_1_2_3).addDefaultStringEntries(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForScan(this.indexOn_1_1_2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldSeekWhenThereAreNewStringNodes() throws Exception {
        this.modifyIndex(this.indexOn_1_1_2).addDefaultStringEntries(42L, 43L);
        this.modifyIndex(this.indexOn_1_2_3).addDefaultStringEntries(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(this.indexOn_1_1_2, ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldSeekWhenThereAreNewNumberNodes() throws Exception {
        this.modifyIndex(this.indexOn_1_1_2).addDefaultStringProperties(42L, 43L);
        this.modifyIndex(this.indexOn_1_2_3).addDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(this.indexOn_1_1_2, ValueTuple.of((Object[])new Object[]{43001.0, 43002.0}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldHandleMixedAddsAndRemovesEntry() throws Exception {
        this.modifyIndex(this.indexOn_1_1_2).addDefaultStringEntries(42L, 43L);
        this.modifyIndex(this.indexOn_1_1_2).removeDefaultStringEntries(43L);
        this.modifyIndex(this.indexOn_1_1_2).removeDefaultStringEntries(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForScan(this.indexOn_1_1_2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L}), (Object)diffSets.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{44L}), (Object)diffSets.getRemoved());
    }

    @Test
    public void shouldSeekWhenThereAreManyEntriesWithTheSameValues() throws Exception {
        this.modifyIndex(this.indexOn_1_1_2).addDefaultStringEntries(42L, 43L);
        this.state.indexDoUpdateEntry(this.indexOn_1_1_2.schema(), 44L, null, this.getDefaultStringPropertyValues(43L, this.indexOn_1_1_2.schema().getPropertyIds()));
        ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(this.indexOn_1_1_2, ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{43L, 44L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldSeekInComplexMix() throws Exception {
        ValueTuple[] values2_1 = (ValueTuple[])Iterators.array((Object[])new ValueTuple[]{ValueTuple.of((Object[])new Object[]{"hi", 3}), ValueTuple.of((Object[])new Object[]{9L, 33L}), ValueTuple.of((Object[])new Object[]{"sneaker", false})});
        ValueTuple[] values2_2 = (ValueTuple[])Iterators.array((Object[])new ValueTuple[]{ValueTuple.of((Object[])new Object[]{true, false}), ValueTuple.of((Object[])new Object[]{new int[]{10, 100}, "array-buddy"}), ValueTuple.of((Object[])new Object[]{40.1, 40.2})});
        ValueTuple[] values3 = (ValueTuple[])Iterators.array((Object[])new ValueTuple[]{ValueTuple.of((Object[])new Object[]{"hi", "ho", "hello"}), ValueTuple.of((Object[])new Object[]{true, new long[]{4L}, 33L}), ValueTuple.of((Object[])new Object[]{2, false, 1})});
        this.addEntries(this.indexOn_1_1_2, values2_1, 10L);
        this.addEntries(this.indexOn_2_2_3, values2_2, 100L);
        this.addEntries(this.indexOn_2_2_3_4, values3, 1000L);
        this.assertSeek(this.indexOn_1_1_2, values2_1, 10L);
        this.assertSeek(this.indexOn_2_2_3, values2_2, 100L);
        this.assertSeek(this.indexOn_2_2_3_4, values3, 1000L);
    }

    private void addEntries(IndexDescriptor index, ValueTuple[] values, long nodeIdStart) {
        for (int i = 0; i < values.length; ++i) {
            this.state.indexDoUpdateEntry(index.schema(), nodeIdStart + (long)i, null, values[i]);
        }
    }

    private void assertSeek(IndexDescriptor index, ValueTuple[] values, long nodeIdStart) {
        for (int i = 0; i < values.length; ++i) {
            ReadableDiffSets diffSets = this.state.indexUpdatesForSeek(index, values[i]);
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{nodeIdStart + (long)i}), (Object)diffSets.getAdded());
        }
    }

    private IndexUpdater modifyIndex(final IndexDescriptor descriptor) {
        return new IndexUpdater(){

            @Override
            public void addDefaultStringEntries(long ... nodeIds) {
                this.addEntries(this.getDefaultStringEntries(nodeIds));
            }

            @Override
            public void removeDefaultStringEntries(long ... nodeIds) {
                this.removeEntries(this.getDefaultStringEntries(nodeIds));
            }

            @Override
            public void addDefaultStringProperties(long ... nodeIds) {
                ArrayList<Pair<Long, ValueTuple>> entries = new ArrayList<Pair<Long, ValueTuple>>(nodeIds.length);
                for (long nodeId : nodeIds) {
                    int[] propertyIds = descriptor.schema().getPropertyIds();
                    Object[] values = new Object[propertyIds.length];
                    for (int i = 0; i < propertyIds.length; ++i) {
                        values[i] = (double)nodeId * 1000.0 + (double)propertyIds[i];
                    }
                    entries.add((Pair<Long, ValueTuple>)Pair.of((Object)nodeId, (Object)ValueTuple.of((Object[])values)));
                }
                this.addEntries(entries);
            }

            void addEntries(Collection<Pair<Long, ValueTuple>> nodesWithValues) {
                for (Pair<Long, ValueTuple> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateCompositeIndexTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, null, (ValueTuple)entry.other());
                }
            }

            void removeEntries(Collection<Pair<Long, ValueTuple>> nodesWithValues) {
                for (Pair<Long, ValueTuple> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateCompositeIndexTest.this.state.indexDoUpdateEntry(descriptor.schema(), nodeId, (ValueTuple)entry.other(), null);
                }
            }

            private Collection<Pair<Long, ValueTuple>> getDefaultStringEntries(long[] nodeIds) {
                ArrayList<Pair<Long, ValueTuple>> entries = new ArrayList<Pair<Long, ValueTuple>>(nodeIds.length);
                for (long nodeId : nodeIds) {
                    int[] propertyIds = descriptor.schema().getPropertyIds();
                    ValueTuple values = TxStateCompositeIndexTest.this.getDefaultStringPropertyValues(nodeId, propertyIds);
                    entries.add((Pair<Long, ValueTuple>)Pair.of((Object)nodeId, (Object)values));
                }
                return entries;
            }
        };
    }

    private ValueTuple getDefaultStringPropertyValues(long nodeId, int[] propertyIds) {
        Object[] values = new Object[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            values[i] = nodeId + "value" + propertyIds[i];
        }
        return ValueTuple.of((Object[])values);
    }

    private static interface IndexUpdater {
        public void addDefaultStringEntries(long ... var1);

        public void removeDefaultStringEntries(long ... var1);

        public void addDefaultStringProperties(long ... var1);
    }
}

