/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TxStateVisitorTest {
    private TransactionState state;
    private final Collection<StorageProperty> noProperty = Collections.emptySet();
    private final Collection<Integer> noRemoved = Collections.emptySet();

    @Test
    public void shouldSeeAddedRelationshipProperties() throws Exception {
        long relId = 1L;
        int propKey = 2;
        GatheringVisitor visitor = new GatheringVisitor();
        Value value = Values.of((Object)"hello");
        this.state.relationshipDoReplaceProperty(relId, propKey, Values.of((Object)""), value);
        this.state.accept((TxStateVisitor)visitor);
        PropertyKeyValue prop = new PropertyKeyValue(propKey, Values.of((Object)"hello"));
        Assert.assertThat(visitor.relPropertyChanges, this.contains(this.propChange(relId, this.noProperty, Arrays.asList(prop), this.noRemoved)));
    }

    private Matcher<List<GatheringVisitor.PropertyChange>> contains(GatheringVisitor.PropertyChange ... change) {
        return CoreMatchers.equalTo(Arrays.asList(change));
    }

    private GatheringVisitor.PropertyChange propChange(long relId, Collection<StorageProperty> added, List<StorageProperty> changed, Collection<Integer> removed) {
        return new GatheringVisitor.PropertyChange(relId, added, changed, removed);
    }

    @Before
    public void before() throws Exception {
        this.state = new TxState();
    }

    static class GatheringVisitor
    extends TxStateVisitor.Adapter {
        public List<PropertyChange> nodePropertyChanges = new ArrayList<PropertyChange>();
        public List<PropertyChange> relPropertyChanges = new ArrayList<PropertyChange>();
        public List<PropertyChange> graphPropertyChanges = new ArrayList<PropertyChange>();

        GatheringVisitor() {
        }

        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
            this.nodePropertyChanges.add(new PropertyChange(id, added, changed, removed));
        }

        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
            this.relPropertyChanges.add(new PropertyChange(id, added, changed, removed));
        }

        public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
            this.graphPropertyChanges.add(new PropertyChange(-1L, added, changed, removed));
        }

        static class PropertyChange {
            final long entityId;
            final List<StorageProperty> added;
            final List<StorageProperty> changed;
            final List<Integer> removed;

            PropertyChange(long entityId, Collection<StorageProperty> added, Collection<StorageProperty> changed, Collection<Integer> removed) {
                this.entityId = entityId;
                this.added = Iterables.asList(added);
                this.changed = Iterables.asList(changed);
                this.removed = Iterables.asList(removed);
            }

            PropertyChange(long entityId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
                this.entityId = entityId;
                this.added = Iterators.asList(added);
                this.changed = Iterators.asList(changed);
                this.removed = Iterators.asList(removed);
            }

            public String toString() {
                return "PropertyChange{entityId=" + this.entityId + ", added=" + this.added + ", changed=" + this.changed + ", removed=" + this.removed + '}';
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PropertyChange that = (PropertyChange)o;
                if (this.entityId != that.entityId) {
                    return false;
                }
                if (!this.added.equals(that.added)) {
                    return false;
                }
                if (!this.changed.equals(that.changed)) {
                    return false;
                }
                return this.removed.equals(that.removed);
            }

            public int hashCode() {
                int result = (int)(this.entityId ^ this.entityId >>> 32);
                result = 31 * result + this.added.hashCode();
                result = 31 * result + this.changed.hashCode();
                result = 31 * result + this.removed.hashCode();
                return result;
            }
        }
    }
}

