/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.lang.reflect.Array;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.api.store.StorageLayerTest;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class StorageLayerPropertyTest
extends StorageLayerTest {
    @Test
    public void should_get_all_node_properties() throws Exception {
        String longString = "AlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalong";
        Object[] properties = new Object[]{longString, this.createNew(String.class), this.createNew(Long.TYPE), this.createNew(Integer.TYPE), this.createNew(Byte.TYPE), this.createNew(Short.TYPE), this.createNew(Boolean.TYPE), this.createNew(Character.TYPE), this.createNew(Float.TYPE), this.createNew(Double.TYPE), this.array(0, String.class), this.array(0, Long.TYPE), this.array(0, Integer.TYPE), this.array(0, Byte.TYPE), this.array(0, Short.TYPE), this.array(0, Boolean.TYPE), this.array(0, Character.TYPE), this.array(0, Float.TYPE), this.array(0, Double.TYPE), this.array(1, String.class), this.array(1, Long.TYPE), this.array(1, Integer.TYPE), this.array(1, Byte.TYPE), this.array(1, Short.TYPE), this.array(1, Boolean.TYPE), this.array(1, Character.TYPE), this.array(1, Float.TYPE), this.array(1, Double.TYPE), this.array(256, String.class), this.array(256, Long.TYPE), this.array(256, Integer.TYPE), this.array(256, Byte.TYPE), this.array(256, Short.TYPE), this.array(256, Boolean.TYPE), this.array(256, Character.TYPE), this.array(256, Float.TYPE), this.array(256, Double.TYPE)};
        int propKey = this.disk.propertyKeyGetOrCreateForName("prop");
        StorageStatement statement = this.state.getStoreStatement();
        for (Object value : properties) {
            long nodeId = StorageLayerPropertyTest.createLabeledNode((GraphDatabaseService)this.db, Collections.singletonMap("prop", value), this.label1).getId();
            try (Cursor node = statement.acquireSingleNodeCursor(nodeId);){
                node.next();
                Lock lock = ((NodeItem)node.get()).lock();
                try (Cursor props = statement.acquireSinglePropertyCursor(((NodeItem)node.get()).nextPropertyId(), propKey, lock, AssertOpen.ALWAYS_OPEN);){
                    if (props.next()) {
                        Value propVal = ((PropertyItem)props.get()).value();
                        Assert.assertTrue((String)(propVal + ".equals(" + value + ")"), (boolean)propVal.equals(Values.of((Object)value)));
                        continue;
                    }
                    Assert.fail();
                }
            }
        }
    }

    @Test
    public void should_create_property_key_if_not_exists() throws Exception {
        long id = this.disk.propertyKeyGetOrCreateForName("name");
        Assert.assertTrue((String)"Should have created a non-negative id", (id >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void should_get_previously_created_property_key() throws Exception {
        long id = this.disk.propertyKeyGetOrCreateForName("name");
        long secondId = this.disk.propertyKeyGetForName("name");
        Assert.assertEquals((long)id, (long)secondId);
    }

    @Test
    public void should_be_able_to_get_or_create_previously_created_property_key() throws Exception {
        long id = this.disk.propertyKeyGetOrCreateForName("name");
        long secondId = this.disk.propertyKeyGetOrCreateForName("name");
        Assert.assertEquals((long)id, (long)secondId);
    }

    @Test
    public void should_fail_if_get_non_existent_property_key() throws Exception {
        int propertyKey = this.disk.propertyKeyGetForName("non-existent-property-key");
        Assert.assertEquals((long)-1L, (long)propertyKey);
    }

    private Object array(int length, Class<?> componentType) {
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.createNew(componentType));
        }
        return array;
    }

    private Object createNew(Class<?> type) {
        if (type == Integer.TYPE) {
            return 666;
        }
        if (type == Long.TYPE) {
            return 17L;
        }
        if (type == Double.TYPE) {
            return Math.PI * 2;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(3.14f);
        }
        if (type == Short.TYPE) {
            return (short)8733;
        }
        if (type == Byte.TYPE) {
            return (byte)123;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('Z');
        }
        if (type == String.class) {
            return "hello world";
        }
        throw new IllegalArgumentException(type.getName());
    }
}

