/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class StoreNodeRelationshipCursorTest {
    private static final long FIRST_OWNING_NODE = 1L;
    private static final long SECOND_OWNING_NODE = 2L;
    private static final int TYPE = 0;
    @ClassRule
    public static TestDirectory directory = TestDirectory.testDirectory(StoreNodeRelationshipCursorTest.class);
    private static FileSystemAbstraction fs;
    private static PageCache pageCache;
    private static NeoStores neoStores;
    @Parameterized.Parameter
    public Direction direction;
    @Parameterized.Parameter(value=1)
    public boolean dense;

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({Direction.BOTH, false}, {Direction.BOTH, true}, {Direction.OUTGOING, false}, {Direction.OUTGOING, true}, {Direction.INCOMING, false}, {Direction.INCOMING, true});
    }

    @BeforeClass
    public static void setupStores() {
        File storeDir = directory.absolutePath();
        fs = new DefaultFileSystemAbstraction();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
        pageCache = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY).getOrCreatePageCache();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(storeDir, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
        neoStores = storeFactory.openAllNeoStores(true);
    }

    @AfterClass
    public static void shutDownStores() throws Exception {
        neoStores.close();
        pageCache.close();
        fs.close();
    }

    @Test
    public void retrieveNodeRelationships() throws Exception {
        this.createNodeRelationships();
        try (StoreNodeRelationshipCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(this.dense, 1L, 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            Assert.assertTrue((boolean)cursor.next());
            cursor.init(this.dense, 2L, 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            Assert.assertTrue((boolean)cursor.next());
            cursor.init(this.dense, 3L, 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test
    public void retrieveUsedRelationshipChain() {
        this.createRelationshipChain(4);
        long expectedNodeId = 1L;
        try (StoreNodeRelationshipCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(this.dense, 1L, 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            while (cursor.next()) {
                Assert.assertEquals((String)"Should load next relationship in a sequence", (long)expectedNodeId++, (long)cursor.get().id());
            }
        }
    }

    @Test
    public void retrieveRelationshipChainWithUnusedLink() {
        neoStores.getRelationshipStore().setHighId(10L);
        this.createRelationshipChain(4);
        this.unUseRecord(3L);
        int[] expectedRelationshipIds = new int[]{1, 2, 4};
        int relationshipIndex = 0;
        try (StoreNodeRelationshipCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(this.dense, 1L, 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            while (cursor.next()) {
                Assert.assertEquals((String)"Should load next relationship in a sequence", (long)expectedRelationshipIds[relationshipIndex++], (long)cursor.get().id());
            }
        }
    }

    @Test
    public void shouldHandleDenseNodeWithNoRelationships() throws Exception {
        try (StoreNodeRelationshipCursor cursor = this.getNodeRelationshipCursor();){
            cursor.init(this.dense, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 1L, this.direction, Predicates.ALWAYS_TRUE_INT);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private void createNodeRelationships() {
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        if (this.dense) {
            RecordStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(1L, 1L));
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(2L, 2L));
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(3L, 3L));
        }
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(1L, Record.NO_NEXT_RELATIONSHIP.intValue()));
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(2L, Record.NO_NEXT_RELATIONSHIP.intValue()));
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(3L, Record.NO_NEXT_RELATIONSHIP.intValue()));
    }

    private void unUseRecord(long recordId) {
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RelationshipRecord relationshipRecord = (RelationshipRecord)relationshipStore.getRecord(recordId, (AbstractBaseRecord)new RelationshipRecord(-1L), RecordLoad.FORCE);
        relationshipRecord.setInUse(false);
        relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord);
    }

    private RelationshipGroupRecord createRelationshipGroup(long id, long relationshipId) {
        return new RelationshipGroupRecord(id, 0, this.getFirstOut(relationshipId), this.getFirstIn(relationshipId), this.getFirstLoop(relationshipId), 1L, true);
    }

    private long getFirstLoop(long firstLoop) {
        return this.direction == Direction.BOTH ? firstLoop : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private long getFirstIn(long firstIn) {
        return this.direction == Direction.INCOMING ? firstIn : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private long getFirstOut(long firstOut) {
        return this.direction == Direction.OUTGOING ? firstOut : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private void createRelationshipChain(int recordsInChain) {
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        for (int i = 1; i < recordsInChain; ++i) {
            relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(i, i + 1));
        }
        relationshipStore.updateRecord((AbstractBaseRecord)this.createRelationship(recordsInChain, Record.NO_NEXT_RELATIONSHIP.intValue()));
        if (this.dense) {
            RecordStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
            for (int i = 1; i < recordsInChain; ++i) {
                relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(i, i));
            }
            relationshipGroupStore.updateRecord((AbstractBaseRecord)this.createRelationshipGroup(recordsInChain, Record.NO_NEXT_RELATIONSHIP.intValue()));
        }
    }

    private RelationshipRecord createRelationship(long id, long nextRelationship) {
        return new RelationshipRecord(id, true, this.getFirstNode(), this.getSecondNode(), 0, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), nextRelationship, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), nextRelationship, false, false);
    }

    private long getSecondNode() {
        return this.getFirstNode() == 1L ? 2L : 1L;
    }

    private long getFirstNode() {
        return this.direction == Direction.OUTGOING ? 1L : 2L;
    }

    private StoreNodeRelationshipCursor getNodeRelationshipCursor() {
        return new StoreNodeRelationshipCursor(new RelationshipRecord(-1L), new RelationshipGroupRecord(-1L, -1), (Consumer)Mockito.mock(Consumer.class), new RecordCursors(neoStores), LockService.NO_LOCK_SERVICE);
    }
}

