/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.test.impl.EphemeralIdGenerator;

public class JumpingIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> generators = new EnumMap<IdType, IdGenerator>(IdType.class);
    private final IdGenerator forTheRest = new EphemeralIdGenerator(null, null);
    private final int sizePerJump;

    public JumpingIdGeneratorFactory(int sizePerJump) {
        this.sizePerJump = sizePerJump;
    }

    public IdGenerator open(File fileName, int grabSize, IdType idType, Supplier<Long> highId, long maxId) {
        return this.get(idType);
    }

    public IdGenerator open(File filename, IdType idType, Supplier<Long> highId, long maxId) {
        return this.get(idType);
    }

    public IdGenerator get(IdType idType) {
        if (idType == IdType.NODE || idType == IdType.RELATIONSHIP || idType == IdType.PROPERTY || idType == IdType.STRING_BLOCK || idType == IdType.ARRAY_BLOCK) {
            IdGenerator generator = this.generators.get(idType);
            if (generator == null) {
                generator = new JumpingIdGenerator();
                this.generators.put(idType, generator);
            }
            return generator;
        }
        return this.forTheRest;
    }

    public void create(File fileName, long highId, boolean throwIfFileExists) {
    }

    private class JumpingIdGenerator
    implements IdGenerator {
        private final AtomicLong nextId = new AtomicLong();
        private int leftToNextJump = JumpingIdGeneratorFactory.access$100(JumpingIdGeneratorFactory.this) / 2;
        private long highBits;

        private JumpingIdGenerator() {
        }

        public long nextId() {
            long result = this.tryNextId();
            if (--this.leftToNextJump == 0) {
                this.leftToNextJump = JumpingIdGeneratorFactory.this.sizePerJump;
                this.nextId.set((0xFFFFFFFFL | this.highBits++ << 32) - (long)(JumpingIdGeneratorFactory.this.sizePerJump / 2) + 1L);
            }
            return result;
        }

        private long tryNextId() {
            long result = this.nextId.getAndIncrement();
            if (IdValidator.isReservedId((long)result)) {
                result = this.nextId.getAndIncrement();
                --this.leftToNextJump;
            }
            return result;
        }

        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }

        public long getHighId() {
            return this.nextId.get();
        }

        public void setHighId(long id) {
            this.nextId.set(id);
        }

        public void freeId(long id) {
        }

        public void close() {
        }

        public long getNumberOfIdsInUse() {
            return this.nextId.get();
        }

        public long getDefragCount() {
            return 0L;
        }

        public void delete() {
        }

        public long getHighestPossibleIdInUse() {
            return this.getHighId() - 1L;
        }
    }
}

