/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;

public class NestedTransactionLocksIT {
    private GraphDatabaseService db;

    @Before
    public void before() throws Exception {
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Lock> acquireWriteLock(Node resource) {
        return state -> {
            try (Transaction tx = this.db.beginTx();){
                Lock lock = tx.acquireWriteLock((PropertyContainer)resource);
                return lock;
            }
        };
    }

    @Test
    public void nestedTransactionCanAcquireLocksFromTransactionObject() throws Exception {
        Node resource = this.createNode();
        try (Transaction outerTx = this.db.beginTx();
             Transaction nestedTx = this.db.beginTx();){
            Assert.assertNotSame((Object)outerTx, (Object)nestedTx);
            try (OtherThreadExecutor otherThread = new OtherThreadExecutor("other thread", null);){
                Lock lock = nestedTx.acquireWriteLock((PropertyContainer)resource);
                Future<Lock> future = this.tryToAcquireSameLockOnAnotherThread(resource, (OtherThreadExecutor<Void>)otherThread);
                this.acquireOnOtherThreadTimesOut(future);
                lock.release();
                Assert.assertNotNull((Object)future.get());
            }
        }
    }

    private void acquireOnOtherThreadTimesOut(Future<Lock> future) throws InterruptedException, ExecutionException {
        try {
            future.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"The nested transaction seems to not have acquired the lock");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private Future<Lock> tryToAcquireSameLockOnAnotherThread(Node resource, OtherThreadExecutor<Void> otherThread) throws Exception {
        Future future = otherThread.executeDontWait(this.acquireWriteLock(resource));
        otherThread.waitUntilWaiting();
        return future;
    }

    private Node createNode() {
        try (Transaction tx = this.db.beginTx();){
            Node n = this.db.createNode();
            tx.success();
            Node node = n;
            return node;
        }
    }
}

