/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.store.id.IdType;

public class TestNeo4j
extends AbstractNeo4jTestCase {
    @Test
    public void testBasicNodeRelationships() {
        Node firstNode = this.getGraphDb().createNode();
        Assert.assertNotNull((String)"Failure creating first node", (Object)firstNode);
        Node secondNode = this.getGraphDb().createNode();
        Assert.assertNotNull((String)"Failure creating second node", (Object)secondNode);
        Relationship rel = firstNode.createRelationshipTo(secondNode, (RelationshipType)MyRelTypes.TEST);
        Assert.assertNotNull((String)"Relationship is null", (Object)rel);
        RelationshipType relType = rel.getType();
        Assert.assertNotNull((String)"Relationship's type is is null", (Object)relType);
        try (ResourceIterator iterator = Iterators.asResourceIterator(firstNode.getRelationships(new RelationshipType[]{relType}).iterator());){
            Assert.assertTrue((boolean)iterator.hasNext());
        }
        iterator = Iterators.asResourceIterator(secondNode.getRelationships(new RelationshipType[]{relType}).iterator());
        var6_6 = null;
        try {
            Assert.assertTrue((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var6_6 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        ResourceIterable allRels = (ResourceIterable)firstNode.getRelationships();
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
        allRels = (ResourceIterable)firstNode.getRelationships(new RelationshipType[]{relType});
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
        allRels = (ResourceIterable)secondNode.getRelationships();
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
        allRels = (ResourceIterable)secondNode.getRelationships(new RelationshipType[]{relType});
        Assert.assertTrue((boolean)this.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
        Object[] relNodes = rel.getNodes();
        Assert.assertEquals((String)"A relationship should always be connected to exactly two nodes", (long)relNodes.length, (long)2L);
        Assert.assertTrue((String)"Relationship says that it isn't connected to firstNode", (boolean)this.objectExistsInArray(firstNode, relNodes));
        Assert.assertTrue((String)"Relationship says that it isn't connected to secondNode", (boolean)this.objectExistsInArray(secondNode, relNodes));
        Assert.assertTrue((String)"The other node should be secondNode but it isn't", (boolean)rel.getOtherNode(firstNode).equals(secondNode));
        Assert.assertTrue((String)"The other node should be firstNode but it isn't", (boolean)rel.getOtherNode(secondNode).equals(firstNode));
        rel.delete();
        secondNode.delete();
        firstNode.delete();
    }

    private boolean objectExistsInIterable(Relationship rel, ResourceIterable<Relationship> allRels) {
        try (ResourceIterator resourceIterator = allRels.iterator();){
            while (resourceIterator.hasNext()) {
                Relationship iteratedRel = (Relationship)resourceIterator.next();
                if (!rel.equals(iteratedRel)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private boolean objectExistsInArray(Object obj, Object[] objArray) {
        for (int i = 0; i < objArray.length; ++i) {
            if (!objArray[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testRandomPropertyName() {
        Node node1 = this.getGraphDb().createNode();
        String key = "random_" + new Random(System.currentTimeMillis()).nextLong();
        node1.setProperty(key, (Object)"value");
        Assert.assertEquals((Object)"value", (Object)node1.getProperty(key));
        node1.delete();
    }

    @Test
    public void testNodeChangePropertyArray() throws Exception {
        Node node;
        this.getTransaction().close();
        try (Transaction tx = this.getGraphDb().beginTx();){
            node = this.getGraphDb().createNode();
            tx.success();
        }
        tx = this.getGraphDb().beginTx();
        var3_2 = null;
        try {
            node.setProperty("test", (Object)new String[]{"value1"});
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var3_2 = null;
        try (Transaction ignored = this.getGraphDb().beginTx();){
            node.setProperty("test", (Object)new String[]{"value1", "value2"});
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        tx = this.getGraphDb().beginTx();
        var3_2 = null;
        try {
            String[] value = (String[])node.getProperty("test");
            Assert.assertEquals((long)1L, (long)value.length);
            Assert.assertEquals((Object)"value1", (Object)value[0]);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testGetAllNodes() {
        long highId = this.getIdGenerator(IdType.NODE).getHighestPossibleIdInUse();
        if (highId >= 0L && highId < 10000L) {
            long count = Iterables.count((Iterable)this.getGraphDb().getAllNodes());
            boolean found = false;
            Node newNode = this.getGraphDb().createNode();
            this.newTransaction();
            long oldCount = count;
            count = 0L;
            for (Node node : this.getGraphDb().getAllNodes()) {
                ++count;
                if (!node.equals(newNode)) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
            Assert.assertEquals((long)count, (long)(oldCount + 1L));
            ResourceIterator allNodesIterator = this.getGraphDb().getAllNodes().iterator();
            Assert.assertNotNull((Object)allNodesIterator.next());
            allNodesIterator.close();
            newNode.delete();
            this.newTransaction();
            found = false;
            count = 0L;
            for (Node node : this.getGraphDb().getAllNodes()) {
                ++count;
                if (!node.equals(newNode)) continue;
                found = true;
            }
            Assert.assertTrue((!found ? 1 : 0) != 0);
            Assert.assertEquals((long)count, (long)oldCount);
        }
    }

    @Test
    public void testMultipleShutdown() {
        this.commit();
        this.getGraphDb().shutdown();
        this.getGraphDb().shutdown();
    }
}

