/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.coreapi.StandardRelationshipActions;

public class StandardRelationshipActionsTest {
    @Test
    public void closeStatementOnRetrievingRelationshipTypeById() throws Exception {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        CountingSupplier statementSupplier = new CountingSupplier(statement);
        StandardRelationshipActions relationshipActions = this.setupRelationshipActions(statement, statementSupplier);
        RelationshipType relationshipType = relationshipActions.getRelationshipTypeById(4);
        Assert.assertEquals((Object)RelationshipType.withName((String)"testType"), (Object)relationshipType);
        Assert.assertEquals((String)"Statement should be acquired only once.", (long)1L, (long)statementSupplier.getInvocationCounter());
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    private StandardRelationshipActions setupRelationshipActions(Statement statement, CountingSupplier statementSupplier) throws RelationshipTypeIdNotFoundKernelException {
        ReadOperations readOperations = this.getReadOperations(statement);
        Mockito.when((Object)statement.readOperations()).thenReturn((Object)readOperations);
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        GraphDatabaseService databaseService = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        LongFunction<Node> longFunction = value -> null;
        return new StandardRelationshipActions((Supplier)statementSupplier, Suppliers.singleton((Object)kernelTransaction), ThrowingAction.noop(), longFunction, databaseService);
    }

    private ReadOperations getReadOperations(Statement statement) throws RelationshipTypeIdNotFoundKernelException {
        ReadOperations readOperations = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)readOperations.relationshipTypeGetName(4)).thenReturn((Object)"testType");
        return readOperations;
    }

    private static class CountingSupplier
    implements Supplier<Statement> {
        private final Statement statement;
        private int invocationCounter;

        CountingSupplier(Statement statement) {
            this.statement = statement;
        }

        @Override
        public Statement get() {
            ++this.invocationCounter;
            return this.statement;
        }

        int getInvocationCounter() {
            return this.invocationCounter;
        }
    }
}

