/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;
import org.neo4j.kernel.impl.index.labelscan.MutableHit;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStoreIT;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.test.rule.RandomRule;

public class NativeLabelScanWriterTest {
    private static final int LABEL_COUNT = 5;
    private static final int NODE_COUNT = 10000;
    private static final Comparator<LabelScanKey> KEY_COMPARATOR = new LabelScanLayout();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldAddLabels() throws Exception {
        ControlledInserter inserter = new ControlledInserter();
        long[] expected = new long[10000];
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(Integer.max(5, 100));){
            writer.initialize((Writer)inserter);
            for (int i = 0; i < 30000; ++i) {
                NodeLabelUpdate update = this.randomUpdate(expected);
                writer.write(update);
            }
        }
        for (int i = 0; i < 5; ++i) {
            long[] expectedNodeIds = NativeLabelScanStoreIT.nodesWithLabel(expected, i);
            long[] actualNodeIds = PrimitiveLongCollections.asArray((PrimitiveLongIterator)new LabelScanValueIterator(inserter.nodesFor(i), new ArrayList()));
            Assert.assertArrayEquals((String)("For label " + i), (long[])expectedNodeIds, (long[])actualNodeIds);
        }
    }

    @Test
    public void shouldNotAcceptUnsortedLabels() throws Exception {
        ControlledInserter inserter = new ControlledInserter();
        boolean failed = false;
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(1);){
            writer.initialize((Writer)inserter);
            writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{2L, 1L}));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("unsorted"));
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    private NodeLabelUpdate randomUpdate(long[] expected) {
        int nodeId = this.random.nextInt(expected.length);
        long labels = expected[nodeId];
        long[] before = NativeLabelScanStoreIT.getLabels(labels);
        int changeCount = this.random.nextInt(4) + 1;
        for (int i = 0; i < changeCount; ++i) {
            labels = NativeLabelScanStoreIT.flipRandom(labels, 5, this.random.random());
        }
        expected[nodeId] = labels;
        return NodeLabelUpdate.labelChanges((long)nodeId, (long[])before, (long[])NativeLabelScanStoreIT.getLabels(labels));
    }

    private static class ControlledInserter
    implements Writer<LabelScanKey, LabelScanValue> {
        private final Map<Integer, Map<LabelScanKey, LabelScanValue>> data = new HashMap<Integer, Map<LabelScanKey, LabelScanValue>>();

        private ControlledInserter() {
        }

        public void close() throws IOException {
        }

        public void put(LabelScanKey key, LabelScanValue value) throws IOException {
            this.merge(key, value, (ValueMerger<LabelScanKey, LabelScanValue>)ValueMergers.overwrite());
        }

        public void merge(LabelScanKey key, LabelScanValue value, ValueMerger<LabelScanKey, LabelScanValue> amender) throws IOException {
            key = ControlledInserter.clone(key);
            value = ControlledInserter.clone(value);
            Map forLabel = this.data.computeIfAbsent(key.labelId, labelId -> new TreeMap(KEY_COMPARATOR));
            LabelScanValue existing = (LabelScanValue)forLabel.get(key);
            if (existing == null) {
                forLabel.put(key, value);
            } else {
                amender.merge((Object)key, (Object)key, (Object)existing, (Object)value);
            }
        }

        private static LabelScanValue clone(LabelScanValue value) {
            LabelScanValue result = new LabelScanValue();
            result.bits = value.bits;
            return result;
        }

        private static LabelScanKey clone(LabelScanKey key) {
            return new LabelScanKey(key.labelId, key.idRange);
        }

        public LabelScanValue remove(LabelScanKey key) throws IOException {
            throw new UnsupportedOperationException("Should not be called");
        }

        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> nodesFor(int labelId) {
            Map<Object, Object> forLabel = this.data.get(labelId);
            if (forLabel == null) {
                forLabel = Collections.emptyMap();
            }
            final Map.Entry[] entries = forLabel.entrySet().toArray(new Map.Entry[forLabel.size()]);
            return new RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>(){
                private int arrayIndex = -1;

                public Hit<LabelScanKey, LabelScanValue> get() {
                    Map.Entry entry = entries[this.arrayIndex];
                    return new MutableHit<LabelScanKey, LabelScanValue>((LabelScanKey)entry.getKey(), (LabelScanValue)entry.getValue());
                }

                public boolean next() {
                    ++this.arrayIndex;
                    return this.arrayIndex < entries.length;
                }

                public void close() {
                }
            };
        }
    }
}

