/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConflictDetectingValueMergerTest {
    private final ConflictDetectingValueMerger<SchemaNumberKey, SchemaNumberValue> detector = new ConflictDetectingValueMerger(true);

    @Test
    public void shouldReportConflictOnSameValueAndDifferentEntityIds() throws Exception {
        Value value = Values.of((Object)123);
        long entityId1 = 10L;
        long entityId2 = 20L;
        SchemaNumberValue merged = this.detector.merge(ConflictDetectingValueMergerTest.key(entityId1, value), ConflictDetectingValueMergerTest.key(entityId2, value), SchemaNumberValue.INSTANCE, SchemaNumberValue.INSTANCE);
        Assert.assertNull((Object)merged);
        try {
            this.detector.checkConflict((Value[])ArrayUtil.array((Object[])new Value[]{value}));
            Assert.fail((String)"Should've detected conflict");
        }
        catch (IndexEntryConflictException e) {
            Assert.assertEquals((long)entityId1, (long)e.getExistingNodeId());
            Assert.assertEquals((long)entityId2, (long)e.getAddedNodeId());
            Assert.assertEquals((Object)value, (Object)e.getSinglePropertyValue());
        }
    }

    @Test
    public void shouldNotReportConflictOnSameValueSameEntityId() throws Exception {
        Value value = Values.of((Object)123);
        long entityId = 10L;
        SchemaNumberValue merged = this.detector.merge(ConflictDetectingValueMergerTest.key(entityId, value), ConflictDetectingValueMergerTest.key(entityId, value), SchemaNumberValue.INSTANCE, SchemaNumberValue.INSTANCE);
        Assert.assertNull((Object)merged);
        this.detector.checkConflict((Value[])ArrayUtil.array((Object[])new Value[0]));
    }

    private static SchemaNumberKey key(long entityId, Value ... value) {
        SchemaNumberKey key = new SchemaNumberKey();
        key.from(entityId, value);
        return key;
    }
}

