/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NonUniqueLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Values;

public class FullScanNonUniqueIndexSamplerTest
extends SchemaNumberIndexTestUtil<SchemaNumberKey, SchemaNumberValue> {
    @Test
    public void shouldIncludeAllValuesInTree() throws Exception {
        IndexSample sample;
        Number[] values = this.generateNumberValues();
        this.buildTree(values);
        try (GBPTree gbpTree = this.getTree();){
            IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, this.layout, samplingConfig);
            sample = sampler.result();
        }
        Assert.assertEquals((long)values.length, (long)sample.sampleSize());
        Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(values), (long)sample.uniqueValues());
        Assert.assertEquals((long)values.length, (long)sample.indexSize());
    }

    private Number[] generateNumberValues() {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        Number[] result = new Number[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            result[i] = (Number)updates[i].values()[0].asObject();
        }
        return result;
    }

    private void buildTree(Number[] values) throws IOException {
        try (GBPTree gbpTree = this.getTree();){
            try (Writer writer = gbpTree.writer();){
                SchemaNumberKey key = (SchemaNumberKey)this.layout.newKey();
                SchemaNumberValue value = (SchemaNumberValue)this.layout.newValue();
                long nodeId = 0L;
                for (Number number : values) {
                    key.from(nodeId, Values.values((Object[])new Object[]{number}));
                    value.from(Values.values((Object[])new Object[]{number}));
                    writer.put((Object)key, (Object)value);
                    ++nodeId;
                }
            }
            gbpTree.checkpoint(IOLimiter.unlimited());
        }
    }

    @Override
    protected LayoutTestUtil<SchemaNumberKey, SchemaNumberValue> createLayoutTestUtil() {
        return new NonUniqueLayoutTestUtil();
    }
}

