/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class LayoutTestUtil<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> {
    private final IndexDescriptor indexDescriptor;
    private static final Number[] ALL_EXTREME_VALUES = new Number[]{(byte)127, (byte)-128, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f), Double.MAX_VALUE, -1.7976931348623157E308, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0, 1234567890123456788L, 1234567890123456789L};

    LayoutTestUtil(IndexDescriptor indexDescriptor) {
        this.indexDescriptor = indexDescriptor;
    }

    abstract Layout<KEY, VALUE> createLayout();

    abstract IndexEntryUpdate<IndexDescriptor>[] someUpdates();

    protected abstract double fractionDuplicates();

    IndexDescriptor indexDescriptor() {
        return this.indexDescriptor;
    }

    void copyValue(VALUE value, VALUE intoValue) {
    }

    int compareIndexedPropertyValue(SchemaNumberKey key1, SchemaNumberKey key2) {
        int typeCompare = Byte.compare(key1.type, key2.type);
        if (typeCompare == 0) {
            return Long.compare(key1.rawValueBits, key2.rawValueBits);
        }
        return typeCompare;
    }

    Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator(final RandomRule random) {
        final double fractionDuplicates = this.fractionDuplicates();
        return new PrefetchingIterator<IndexEntryUpdate<IndexDescriptor>>(){
            private final Set<Double> uniqueCompareValues = new HashSet<Double>();
            private final List<Value> uniqueValues = new ArrayList<Value>();
            private long currentEntityId;

            protected IndexEntryUpdate<IndexDescriptor> fetchNextOrNull() {
                Value value = fractionDuplicates > 0.0 && !this.uniqueValues.isEmpty() && (double)random.nextFloat() < fractionDuplicates ? this.existingNonUniqueValue(random) : this.newUniqueValue(random);
                return LayoutTestUtil.this.add(this.currentEntityId++, value);
            }

            private Value newUniqueValue(RandomRule randomRule) {
                Number value;
                Double compareValue;
                while (!this.uniqueCompareValues.add(compareValue = Double.valueOf((value = randomRule.numberPropertyValue()).doubleValue()))) {
                }
                Value numberValue = Values.of((Object)value);
                this.uniqueValues.add(numberValue);
                return numberValue;
            }

            private Value existingNonUniqueValue(RandomRule randomRule) {
                return this.uniqueValues.get(randomRule.nextInt(this.uniqueValues.size()));
            }
        };
    }

    IndexEntryUpdate<IndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    IndexEntryUpdate<IndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor((Number[])ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }

    private IndexEntryUpdate<IndexDescriptor>[] generateAddUpdatesFor(Number[] values) {
        IndexEntryUpdate[] indexEntryUpdates = new IndexEntryUpdate[values.length];
        for (int i = 0; i < indexEntryUpdates.length; ++i) {
            indexEntryUpdates[i] = this.add(i, Values.of((Object)values[i]));
        }
        return indexEntryUpdates;
    }

    protected IndexEntryUpdate<IndexDescriptor> add(long nodeId, Value value) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{value});
    }

    static int countUniqueValues(IndexEntryUpdate<IndexDescriptor>[] updates) {
        return Stream.of(updates).map(update -> update.values()[0]).collect(Collectors.toSet()).size();
    }

    static int countUniqueValues(Number[] updates) {
        return Stream.of(updates).collect(Collectors.toSet()).size();
    }
}

