/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeNonUniqueSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.NonUniqueLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Values;

public class NativeNonUniqueSchemaNumberIndexPopulatorTest
extends NativeSchemaNumberIndexPopulatorTest<SchemaNumberKey, SchemaNumberValue> {
    @Override
    NativeSchemaNumberIndexPopulator<SchemaNumberKey, SchemaNumberValue> createPopulator(PageCache pageCache, FileSystemAbstraction fs, File indexFile, Layout<SchemaNumberKey, SchemaNumberValue> layout, IndexSamplingConfig samplingConfig) {
        return new NativeNonUniqueSchemaNumberIndexPopulator(pageCache, fs, indexFile, layout, samplingConfig, this.monitor, this.indexDescriptor, this.indexId);
    }

    @Test
    public void addShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        this.populator.add(Arrays.asList(updates));
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void updaterShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.close(true);
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldSampleUpdatesIfConfiguredForOnlineSampling() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] scanUpdates = this.layoutUtil.someUpdates();
        this.populator.add(Arrays.asList(scanUpdates));
        Number[] updates = (Number[])ArrayUtil.array((Object[])new Integer[]{101, 102, 102, 103, 103});
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);){
            long nodeId = 1000L;
            for (Number number : updates) {
                IndexEntryUpdate<IndexDescriptor> update = this.layoutUtil.add(nodeId++, Values.of((Object)number));
                updater.process(update);
                this.populator.includeSample(update);
            }
        }
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        Assert.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true);
    }

    @Override
    protected LayoutTestUtil<SchemaNumberKey, SchemaNumberValue> createLayoutTestUtil() {
        return new NonUniqueLayoutTestUtil();
    }
}

