/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SchemaNumberIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NativeSchemaNumberIndexAccessorTest<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends SchemaNumberIndexTestUtil<KEY, VALUE> {
    private NativeSchemaNumberIndexAccessor<KEY, VALUE> accessor;

    @Before
    public void setupAccessor() throws IOException {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        this.createAccessorWithSamplingConfig(samplingConfig);
    }

    private void createAccessorWithSamplingConfig(IndexSamplingConfig samplingConfig) throws IOException {
        this.accessor = new NativeSchemaNumberIndexAccessor(this.pageCache, (FileSystemAbstraction)this.fs, this.indexFile, this.layout, RecoveryCleanupWorkCollector.immediate(), this.monitor, this.indexDescriptor, this.indexId, samplingConfig);
    }

    @After
    public void closeAccessor() throws IOException {
        this.accessor.close();
    }

    @Test
    public void shouldHandleCloseWithoutCallsToProcess() throws Exception {
        IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
    }

    @Test
    public void processMustThrowAfterClose() throws Exception {
        IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
        try {
            updater.process(this.simpleUpdate());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldIndexAdd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            this.processAll(updater, updates);
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexChange() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            Number newValue;
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            switch (i % 3) {
                case 0: {
                    newValue = 32768L + (long)i;
                    break;
                }
                case 1: {
                    newValue = Float.valueOf(32768.0f + (float)i);
                    break;
                }
                case 2: {
                    newValue = 32768.0 + (double)i;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            updates[i] = IndexEntryUpdate.change((long)update.getEntityId(), (LabelSchemaSupplier)this.indexDescriptor, (Value)update.values()[0], (Value)Values.of((Object)newValue));
        }
        this.processAll(updates);
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexRemove() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<IndexDescriptor> update = updates[i];
            IndexEntryUpdate remove = IndexEntryUpdate.remove((long)update.getEntityId(), (LabelSchemaSupplier)this.indexDescriptor, (Value[])update.values());
            this.processAll(remove);
            this.forceAndCloseAccessor();
            this.verifyUpdates(Arrays.copyOfRange(updates, i + 1, updates.length));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldHandleRandomUpdates() throws Exception {
        HashSet<IndexEntryUpdate<IndexDescriptor>> expectedData = new HashSet<IndexEntryUpdate<IndexDescriptor>>();
        Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator = this.layoutUtil.randomUpdateGenerator(this.random);
        int rounds = 50;
        for (int round = 0; round < rounds; ++round) {
            IndexEntryUpdate<IndexDescriptor>[] batch = this.generateRandomUpdates(expectedData, newDataGenerator, this.random.nextInt(5, 20), (float)round / (float)rounds * 2.0f);
            this.processAll(batch);
            this.applyUpdatesToExpectedData(expectedData, batch);
            this.forceAndCloseAccessor();
            this.verifyUpdates(expectedData.toArray(new IndexEntryUpdate[expectedData.size()]));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldReturnZeroCountForEmptyIndex() throws Exception {
        try (IndexReader reader = this.accessor.newReader();){
            long count = reader.countIndexedNodes(123L, new Value[]{Values.of((Object)456)});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountOneForExistingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                long count = reader.countIndexedNodes(update.getEntityId(), update.values());
                Assert.assertEquals((long)1L, (long)count);
            }
            long count = reader.countIndexedNodes(123L, new Value[]{Values.of((Object)456)});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountZeroForMismatchingData() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            long countWithMismatchingData = reader.countIndexedNodes(update.getEntityId() + 1L, update.values());
            long countWithNonExistentEntityId = reader.countIndexedNodes(1000000000L, update.values());
            long countWithNonExistentValue = reader.countIndexedNodes(update.getEntityId(), new Value[]{Values.of((Object)32768L)});
            Assert.assertEquals((long)0L, (long)countWithMismatchingData);
            Assert.assertEquals((long)0L, (long)countWithNonExistentEntityId);
            Assert.assertEquals((long)0L, (long)countWithNonExistentValue);
        }
    }

    @Test
    public void shouldReturnAllEntriesForExistsPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.exists((int)0)});
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnNoEntriesForExistsPredicateForEmptyIndex() throws Exception {
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.exists((int)0)});
        long[] actual = PrimitiveLongCollections.asArray((PrimitiveLongIterator)result);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void shouldReturnMatchingEntriesForExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            Value value = update.values()[0];
            PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)value)});
            this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.in((Object[])new Value[]{value})), result);
        }
    }

    @Test
    public void shouldReturnNoEntriesForMismatchingExactPredicate() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        Long value = 32768L;
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)value)});
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.range((int)0, (Number)Double.NEGATIVE_INFINITY, (boolean)true, (Number)Double.POSITIVE_INFINITY, (boolean)false)});
        this.assertEntityIdHits(this.extractEntityIds(updates, NativeSchemaNumberIndexAccessorTest.lessThan(Double.POSITIVE_INFINITY)), result);
    }

    private static int compare(Value value, Number other) {
        return Values.COMPARATOR.compare(value, Values.of((Object)other));
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.range((int)0, (Number)Double.NEGATIVE_INFINITY, (boolean)true, (Number)Double.POSITIVE_INFINITY, (boolean)true)});
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.range((int)0, (Number)Double.NEGATIVE_INFINITY, (boolean)false, (Number)Double.POSITIVE_INFINITY, (boolean)false)});
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.all((Predicate[])new Predicate[]{NativeSchemaNumberIndexAccessorTest.greaterThan(Double.NEGATIVE_INFINITY), NativeSchemaNumberIndexAccessorTest.lessThan(Double.POSITIVE_INFINITY)})), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.range((int)0, (Number)Double.NEGATIVE_INFINITY, (boolean)false, (Number)Double.POSITIVE_INFINITY, (boolean)true)});
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.all((Predicate[])new Predicate[]{NativeSchemaNumberIndexAccessorTest.greaterThan(Double.NEGATIVE_INFINITY), NativeSchemaNumberIndexAccessorTest.greaterThan(Double.NEGATIVE_INFINITY)})), result);
    }

    @Test
    public void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = reader.query(new IndexQuery[]{IndexQuery.range((int)0, (Number)32768L, (boolean)true, (Number)32778L, (boolean)true)});
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test(timeout=10000L)
    public void mustHandleNestedQueries() throws Exception {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)}), IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)1)}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)2)}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)3)})};
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery.NumberRangePredicate outerQuery = IndexQuery.range((int)0, (Number)2, (boolean)true, (Number)3, (boolean)true);
        IndexQuery.NumberRangePredicate innerQuery = IndexQuery.range((int)0, (Number)0, (boolean)true, (Number)1, (boolean)true);
        long[] expectedOuter = new long[]{2L, 3L};
        long[] expectedInner = new long[]{0L, 1L};
        PrimitiveLongIterator outerIter = reader.query(new IndexQuery[]{outerQuery});
        ArrayList<Long> outerResult = new ArrayList<Long>();
        while (outerIter.hasNext()) {
            outerResult.add(outerIter.next());
            PrimitiveLongIterator innerIter = reader.query(new IndexQuery[]{innerQuery});
            this.assertEntityIdHits(expectedInner, innerIter);
        }
        this.assertEntityIdHits(expectedOuter, outerResult);
    }

    @Test(timeout=10000L)
    public void mustHandleMultipleNestedQueries() throws Exception {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)}), IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)1)}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)2)}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)3)}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)4)}), IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)5)})};
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery.NumberRangePredicate query1 = IndexQuery.range((int)0, (Number)4, (boolean)true, (Number)5, (boolean)true);
        IndexQuery.NumberRangePredicate query2 = IndexQuery.range((int)0, (Number)2, (boolean)true, (Number)3, (boolean)true);
        IndexQuery.NumberRangePredicate query3 = IndexQuery.range((int)0, (Number)0, (boolean)true, (Number)1, (boolean)true);
        long[] expected1 = new long[]{4L, 5L};
        long[] expected2 = new long[]{2L, 3L};
        long[] expected3 = new long[]{0L, 1L};
        ArrayList<Long> result1 = new ArrayList<Long>();
        PrimitiveLongIterator iter1 = reader.query(new IndexQuery[]{query1});
        while (iter1.hasNext()) {
            result1.add(iter1.next());
            ArrayList<Long> result2 = new ArrayList<Long>();
            PrimitiveLongIterator iter2 = reader.query(new IndexQuery[]{query2});
            while (iter2.hasNext()) {
                result2.add(iter2.next());
                ArrayList<Long> result3 = new ArrayList<Long>();
                PrimitiveLongIterator iter3 = reader.query(new IndexQuery[]{query3});
                while (iter3.hasNext()) {
                    result3.add(iter3.next());
                }
                this.assertEntityIdHits(expected3, result3);
            }
            this.assertEntityIdHits(expected2, result2);
        }
        this.assertEntityIdHits(expected1, result1);
    }

    @Test
    public void shouldHandleMultipleConsecutiveUpdaters() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates;
        for (IndexEntryUpdate<IndexDescriptor> update : updates = this.layoutUtil.someUpdates()) {
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void requestForSecondUpdaterMustThrow() throws Exception {
        try (IndexUpdater ignored = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            try {
                this.accessor.newUpdater(IndexUpdateMode.ONLINE);
                Assert.fail((String)"Should have failed");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void dropShouldDeleteAndCloseIndex() throws Exception {
        this.assertFilePresent();
        this.accessor.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void forceShouldCheckpointTree() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.layoutUtil.someUpdates();
        this.processAll(data);
        this.accessor.force(IOLimiter.unlimited());
        this.accessor.close();
        this.verifyUpdates(data);
    }

    @Test
    public void closeShouldCloseTreeWithoutCheckpoint() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] data = this.layoutUtil.someUpdates();
        this.processAll(data);
        this.accessor.close();
        this.verifyUpdates(new IndexEntryUpdate[0]);
    }

    @Test
    public void snapshotFilesShouldReturnIndexFile() throws Exception {
        ResourceIterator files = this.accessor.snapshotFiles();
        Assert.assertTrue((boolean)files.hasNext());
        Assert.assertEquals((Object)this.indexFile, (Object)files.next());
        Assert.assertFalse((boolean)files.hasNext());
    }

    @Test
    public void shouldSampleIndex() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            IndexSampler sampler = reader.createSampler();
            IndexSample sample = sampler.sampleIndex();
            Assert.assertEquals((long)updates.length, (long)sample.indexSize());
            Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
            Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        }
    }

    @Test
    public void readingAfterDropShouldThrow() throws Exception {
        this.accessor.drop();
        try {
            this.accessor.newReader();
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void writingAfterDropShouldThrow() throws Exception {
        this.accessor.drop();
        try {
            this.accessor.newUpdater(IndexUpdateMode.ONLINE);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void readingAfterCloseShouldThrow() throws Exception {
        this.accessor.close();
        try {
            this.accessor.newReader();
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void writingAfterCloseShouldThrow() throws Exception {
        this.accessor.close();
        try {
            this.accessor.newUpdater(IndexUpdateMode.ONLINE);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldSeeAllEntriesInAllEntriesReader() throws Exception {
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Stream.of(updates).map(IndexEntryUpdate::getEntityId).collect(Collectors.toCollection(HashSet::new));
        Assert.assertEquals((Object)expectedIds, (Object)ids);
    }

    @Test
    public void shouldSeeNoEntriesInAllEntriesReaderOnEmptyIndex() throws Exception {
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Collections.emptySet();
        Assert.assertEquals(expectedIds, (Object)ids);
    }

    private static Predicate<Value> lessThan(Double other) {
        return t -> NativeSchemaNumberIndexAccessorTest.compare(t, other) < 0;
    }

    private static Predicate<Value> greaterThan(Double other) {
        return t -> NativeSchemaNumberIndexAccessorTest.compare(t, other) > 0;
    }

    private void assertEntityIdHits(long[] expected, PrimitiveLongIterator result) {
        long[] actual = PrimitiveLongCollections.asArray((PrimitiveLongIterator)result);
        this.assertSameContent(expected, actual);
    }

    private void assertEntityIdHits(long[] expected, Collection<Long> result) {
        long[] actual = new long[result.size()];
        int index = 0;
        for (Long aLong : result) {
            actual[index++] = aLong;
        }
        this.assertSameContent(expected, actual);
    }

    private void assertSameContent(long[] expected, long[] actual) {
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assert.assertArrayEquals((String)String.format("Expected arrays to be equal but wasn't.%nexpected:%s%n  actual:%s%n", Arrays.toString(expected), Arrays.toString(actual)), (long[])expected, (long[])actual);
    }

    private long[] extractEntityIds(IndexEntryUpdate<?>[] updates, Predicate<Value> valueFilter) {
        long[] entityIds = new long[updates.length];
        int cursor = 0;
        for (IndexEntryUpdate<?> update : updates) {
            if (!valueFilter.test(update.values()[0])) continue;
            entityIds[cursor++] = update.getEntityId();
        }
        return Arrays.copyOf(entityIds, cursor);
    }

    private void applyUpdatesToExpectedData(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, IndexEntryUpdate<IndexDescriptor>[] batch) {
        for (IndexEntryUpdate<IndexDescriptor> update : batch) {
            IndexEntryUpdate<IndexDescriptor> addition = null;
            IndexEntryUpdate<IndexDescriptor> removal = null;
            switch (update.updateMode()) {
                case ADDED: {
                    addition = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                case CHANGED: {
                    addition = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    removal = this.layoutUtil.add(update.getEntityId(), update.beforeValues()[0]);
                    break;
                }
                case REMOVED: {
                    removal = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(update.updateMode().name());
                }
            }
            if (removal != null) {
                expectedData.remove(removal);
            }
            if (addition == null) continue;
            expectedData.add(addition);
        }
    }

    private IndexEntryUpdate<IndexDescriptor>[] generateRandomUpdates(Set<IndexEntryUpdate<IndexDescriptor>> expectedData, Iterator<IndexEntryUpdate<IndexDescriptor>> newDataGenerator, int count, float removeFactor) {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        float addChangeRatio = 0.5f;
        for (int i = 0; i < count; ++i) {
            float factor = this.random.nextFloat();
            if (!expectedData.isEmpty() && factor < removeFactor) {
                IndexEntryUpdate<IndexDescriptor> toRemove = this.selectRandomItem(expectedData);
                updates[i] = IndexEntryUpdate.remove((long)toRemove.getEntityId(), (LabelSchemaSupplier)this.indexDescriptor, (Value[])toRemove.values());
                continue;
            }
            if (!expectedData.isEmpty() && factor < (1.0f - removeFactor) * addChangeRatio) {
                IndexEntryUpdate<IndexDescriptor> toChange = this.selectRandomItem(expectedData);
                IndexEntryUpdate<IndexDescriptor> updateContainingValue = newDataGenerator.next();
                updates[i] = IndexEntryUpdate.change((long)toChange.getEntityId(), (LabelSchemaSupplier)this.indexDescriptor, (Value[])toChange.values(), (Value[])updateContainingValue.values());
                continue;
            }
            updates[i] = newDataGenerator.next();
        }
        return updates;
    }

    private IndexEntryUpdate<IndexDescriptor> selectRandomItem(Set<IndexEntryUpdate<IndexDescriptor>> expectedData) {
        return expectedData.toArray(new IndexEntryUpdate[expectedData.size()])[this.random.nextInt(expectedData.size())];
    }

    @SafeVarargs
    private final void processAll(IndexEntryUpdate<IndexDescriptor> ... updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    private void forceAndCloseAccessor() throws IOException {
        this.accessor.force(IOLimiter.unlimited());
        this.closeAccessor();
    }

    private void processAll(IndexUpdater updater, IndexEntryUpdate<IndexDescriptor>[] updates) throws IOException, IndexEntryConflictException {
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
    }

    private IndexEntryUpdate<IndexDescriptor> simpleUpdate() {
        return IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)this.indexDescriptor, (Value[])new Value[]{Values.of((Object)0)});
    }
}

