/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.NativeUniqueSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.kernel.impl.index.schema.UniqueLayoutTestUtil;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NativeUniqueSchemaNumberIndexPopulatorTest
extends NativeSchemaNumberIndexPopulatorTest<SchemaNumberKey, SchemaNumberValue> {
    @Override
    NativeSchemaNumberIndexPopulator<SchemaNumberKey, SchemaNumberValue> createPopulator(PageCache pageCache, FileSystemAbstraction fs, File indexFile, Layout<SchemaNumberKey, SchemaNumberValue> layout, IndexSamplingConfig samplingConfig) {
        return new NativeUniqueSchemaNumberIndexPopulator(pageCache, fs, indexFile, layout, samplingConfig, this.monitor, this.indexDescriptor, this.indexId);
    }

    @Override
    protected LayoutTestUtil<SchemaNumberKey, SchemaNumberValue> createLayoutTestUtil() {
        return new UniqueLayoutTestUtil();
    }

    @Test
    public void addShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        try {
            this.populator.add(Arrays.asList(updates));
            Assert.fail((String)"Updates should have conflicted");
        }
        catch (IndexEntryConflictException indexEntryConflictException) {
        }
        finally {
            this.populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updaterShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
        try {
            updater.close();
            Assert.fail((String)"Updates should have conflicted");
        }
        catch (Throwable e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IndexEntryConflictException.class}));
        }
        finally {
            this.populator.close(true);
        }
    }

    @Test
    public void shouldSampleUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<IndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.populator.add(Arrays.asList(updates));
        for (IndexEntryUpdate<IndexDescriptor> update : updates) {
            this.populator.includeSample(update);
        }
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assert.assertEquals((long)updates.length, (long)sample.uniqueValues());
        Assert.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true);
    }
}

