/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.impl.index.schema.NonUniqueNumberLayout;
import org.neo4j.kernel.impl.index.schema.NumberLayout;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.UniqueNumberLayout;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class RawBitsTest {
    @Parameterized.Parameter
    public String name;
    @Parameterized.Parameter(value=1)
    public NumberLayout layout;
    final List<Object> objects = Arrays.asList(Double.NEGATIVE_INFINITY, -1.7976931348623157E308, Long.MIN_VALUE, -9223372036854775807L, Integer.MIN_VALUE, (short)Short.MIN_VALUE, (byte)-128, 0, Double.MIN_VALUE, Double.MIN_NORMAL, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_NORMAL), 1L, 1.1, Float.valueOf(1.2f), Math.E, Math.PI, (byte)10, (short)20, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, 0x2000000, Float.valueOf(3.3554432E7f), 0x2000001, Float.valueOf(3.3554432E7f), 0x2000002, Float.valueOf(3.3554432E7f), 0x1FFFFFFFFFFFFFL, 9.007199254740991E15, 0x20000000000000L, 9.007199254740992E15, 0x20000000000001L, 9.007199254740992E15, 0x20000000000002L, 9.007199254740994E15, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN, Math.nextDown(Math.E), Math.nextUp(Math.E), Math.nextDown(Math.PI), Math.nextUp(Math.PI));

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> layouts() {
        return Arrays.asList({"Unique", new UniqueNumberLayout()}, {"NonUnique", new NonUniqueNumberLayout()});
    }

    @Test
    public void mustSortInSameOrderAsValueComparator() throws Exception {
        List<Value> values = this.asValueObjects(this.objects);
        List<SchemaNumberKey> schemaNumberKeys = this.asSchemaNumberKeys(values);
        Collections.shuffle(values);
        Collections.shuffle(schemaNumberKeys);
        values.sort(Values.COMPARATOR);
        schemaNumberKeys.sort((Comparator<SchemaNumberKey>)this.layout);
        List<Value> actual = this.asValues(schemaNumberKeys);
        this.assertSameOrder(actual, values);
    }

    @Test
    public void shouldCompareAllValuesToAllOtherValuesLikeValueComparator() throws Exception {
        List<Value> values = this.asValueObjects(this.objects);
        List<SchemaNumberKey> schemaNumberKeys = this.asSchemaNumberKeys(values);
        values.sort(Values.COMPARATOR);
        for (SchemaNumberKey numberKey : schemaNumberKeys) {
            List<SchemaNumberKey> withoutThisOne = new ArrayList<SchemaNumberKey>(schemaNumberKeys);
            Assert.assertTrue((boolean)withoutThisOne.remove(numberKey));
            withoutThisOne = Collections.unmodifiableList(withoutThisOne);
            for (int i = 0; i < withoutThisOne.size(); ++i) {
                ArrayList<SchemaNumberKey> withThisOneInWrongPlace = new ArrayList<SchemaNumberKey>(withoutThisOne);
                withThisOneInWrongPlace.add(i, numberKey);
                withThisOneInWrongPlace.sort((Comparator<SchemaNumberKey>)this.layout);
                List<Value> actual = this.asValues(withThisOneInWrongPlace);
                this.assertSameOrder(actual, values);
            }
        }
    }

    @Test
    public void shouldHaveSameCompareResultsAsValueCompare() throws Exception {
        List<Value> values = this.asValueObjects(this.objects);
        List<SchemaNumberKey> schemaNumberKeys = this.asSchemaNumberKeys(values);
        for (int i = 0; i < values.size(); ++i) {
            Value value1 = values.get(i);
            SchemaNumberKey schemaNumberKey1 = schemaNumberKeys.get(i);
            for (int j = 0; j < values.size(); ++j) {
                Value value2 = values.get(j);
                SchemaNumberKey schemaNumberKey2 = schemaNumberKeys.get(j);
                Assert.assertEquals((long)Values.COMPARATOR.compare(value1, value2), (long)this.layout.compare(schemaNumberKey1, schemaNumberKey2));
                Assert.assertEquals((long)Values.COMPARATOR.compare(value2, value1), (long)this.layout.compare(schemaNumberKey2, schemaNumberKey1));
            }
        }
    }

    private List<Value> asValues(List<SchemaNumberKey> schemaNumberKeys) {
        return schemaNumberKeys.stream().map(k -> RawBits.asNumberValue((long)k.rawValueBits, (byte)k.type)).collect(Collectors.toList());
    }

    private void assertSameOrder(List<Value> actual, List<Value> values) {
        Assert.assertEquals((long)actual.size(), (long)values.size());
        for (int i = 0; i < actual.size(); ++i) {
            Number actualAsNumber = (Number)actual.get(i).asObject();
            Number valueAsNumber = (Number)values.get(i).asObject();
            if (Double.isNaN(actualAsNumber.doubleValue()) && Double.isNaN(valueAsNumber.doubleValue())) continue;
            Assert.assertEquals((Object)actual.get(i), (Object)values.get(i));
        }
    }

    private List<Value> asValueObjects(List<Object> objects) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Object object : objects) {
            values.add(Values.of((Object)object));
        }
        return values;
    }

    private List<SchemaNumberKey> asSchemaNumberKeys(List<Value> values) {
        ArrayList<SchemaNumberKey> schemaNumberKeys = new ArrayList<SchemaNumberKey>();
        for (Value value : values) {
            SchemaNumberKey key = new SchemaNumberKey();
            key.from(0L, new Value[]{value});
            schemaNumberKeys.add(key);
        }
        return schemaNumberKeys;
    }
}

