/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public abstract class SchemaNumberIndexTestUtil<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> {
    static final long NON_EXISTENT_VALUE = 32768L;
    static final long NON_EXISTENT_ENTITY_ID = 1000000000L;
    final FileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withAccessChecks(true));
    protected final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule).around((TestRule)this.random);
    IndexDescriptor indexDescriptor;
    LayoutTestUtil<KEY, VALUE> layoutUtil;
    Layout<KEY, VALUE> layout;
    File indexFile;
    PageCache pageCache;
    SchemaIndexProvider.Monitor monitor = SchemaIndexProvider.Monitor.EMPTY;
    long indexId = 1L;

    @Before
    public void setup() {
        this.layoutUtil = this.createLayoutTestUtil();
        this.indexDescriptor = this.layoutUtil.indexDescriptor();
        this.layout = this.layoutUtil.createLayout();
        this.indexFile = this.directory.file("index");
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
    }

    abstract LayoutTestUtil<KEY, VALUE> createLayoutTestUtil();

    private void copyValue(VALUE value, VALUE intoValue) {
        this.layoutUtil.copyValue(value, intoValue);
    }

    void verifyUpdates(IndexEntryUpdate<IndexDescriptor>[] updates) throws IOException {
        Hit<KEY, VALUE>[] expectedHits = this.convertToHits(updates, this.layout);
        ArrayList<Hit<KEY, VALUE>> actualHits = new ArrayList<Hit<KEY, VALUE>>();
        try (GBPTree<KEY, VALUE> tree = this.getTree();
             RawCursor<Hit<KEY, VALUE>, IOException> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy((Hit)scan.get()));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare(h1.key(), h2.key());
            if (keyCompare == 0) {
                return this.layoutUtil.compareIndexedPropertyValue((SchemaNumberKey)h1.key(), (SchemaNumberKey)h2.key());
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits.toArray(new Hit[0]), hitComparator);
    }

    GBPTree<KEY, VALUE> getTree() throws IOException {
        return new GBPTree(this.pageCache, this.indexFile, this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.immediate());
    }

    private RawCursor<Hit<KEY, VALUE>, IOException> scan(GBPTree<KEY, VALUE> tree) throws IOException {
        SchemaNumberKey lowest = (SchemaNumberKey)this.layout.newKey();
        lowest.initAsLowest();
        SchemaNumberKey highest = (SchemaNumberKey)this.layout.newKey();
        highest.initAsHighest();
        return tree.seek((Object)lowest, (Object)highest);
    }

    private void assertSameHits(Hit<KEY, VALUE>[] expectedHits, Hit<KEY, VALUE>[] actualHits, Comparator<Hit<KEY, VALUE>> comparator) {
        Arrays.sort(expectedHits, comparator);
        Arrays.sort(actualHits, comparator);
        Assert.assertEquals((String)String.format("Array length differ%nExpected:%s%nActual:%s", Arrays.toString(expectedHits), Arrays.toString(actualHits)), (long)expectedHits.length, (long)actualHits.length);
        for (int i = 0; i < expectedHits.length; ++i) {
            Hit<KEY, VALUE> expected = expectedHits[i];
            Hit<KEY, VALUE> actual = actualHits[i];
            Assert.assertTrue((String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual), (comparator.compare(expected, actual) == 0 ? 1 : 0) != 0);
        }
    }

    private Hit<KEY, VALUE> deepCopy(Hit<KEY, VALUE> from) {
        SchemaNumberKey intoKey = (SchemaNumberKey)this.layout.newKey();
        SchemaNumberValue intoValue = (SchemaNumberValue)this.layout.newValue();
        this.layout.copyKey(from.key(), (Object)intoKey);
        this.copyValue((SchemaNumberValue)from.value(), intoValue);
        return new SimpleHit(this, intoKey, intoValue);
    }

    private Hit<KEY, VALUE>[] convertToHits(IndexEntryUpdate<IndexDescriptor>[] updates, Layout<KEY, VALUE> layout) {
        ArrayList<Hit<SchemaNumberKey, SchemaNumberValue>> hits = new ArrayList<Hit<SchemaNumberKey, SchemaNumberValue>>(updates.length);
        for (IndexEntryUpdate<IndexDescriptor> u : updates) {
            SchemaNumberKey key = (SchemaNumberKey)layout.newKey();
            key.from(u.getEntityId(), u.values());
            SchemaNumberValue value = (SchemaNumberValue)layout.newValue();
            value.from(u.values());
            hits.add(this.hit(key, value));
        }
        return hits.toArray(new Hit[0]);
    }

    private Hit<KEY, VALUE> hit(KEY key, VALUE value) {
        return new SimpleHit(this, key, value);
    }

    void assertFilePresent() {
        Assert.assertTrue((boolean)this.fs.fileExists(this.indexFile));
    }

    void assertFileNotPresent() {
        Assert.assertFalse((boolean)this.fs.fileExists(this.indexFile));
    }

    private static class SimpleHit
    implements Hit<KEY, VALUE> {
        private final KEY key;
        private final VALUE value;
        final /* synthetic */ SchemaNumberIndexTestUtil this$0;

        SimpleHit(KEY key, VALUE value) {
            this.this$0 = var1_1;
            this.key = key;
            this.value = value;
        }

        public KEY key() {
            return this.key;
        }

        public VALUE value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hit simpleHit = (Hit)o;
            return Objects.equals(this.key(), simpleHit.key()) && Objects.equals(this.value, simpleHit.value());
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "[" + this.key + "," + this.value + "]";
        }
    }
}

