/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;

public class FusionIndexAccessorTest {
    private IndexAccessor nativeAccessor;
    private IndexAccessor luceneAccessor;
    private FusionIndexAccessor fusionIndexAccessor;
    private final long indexId = 10L;
    private final FusionSchemaIndexProvider.DropAction dropAction = (FusionSchemaIndexProvider.DropAction)Mockito.mock(FusionSchemaIndexProvider.DropAction.class);

    @Before
    public void setup() {
        this.nativeAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        this.luceneAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        this.fusionIndexAccessor = new FusionIndexAccessor(this.nativeAccessor, this.luceneAccessor, (FusionSchemaIndexProvider.Selector)new NativeSelector(), 10L, this.dropAction);
    }

    @Test
    public void dropMustDropNativeAndLucene() throws Exception {
        this.fusionIndexAccessor.drop();
        ((IndexAccessor)Mockito.verify((Object)this.nativeAccessor, (VerificationMode)VerificationModeFactory.times((int)1))).drop();
        ((IndexAccessor)Mockito.verify((Object)this.luceneAccessor, (VerificationMode)VerificationModeFactory.times((int)1))).drop();
        ((FusionSchemaIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(10L);
    }

    @Test
    public void dropMustThrowIfDropNativeFail() throws Exception {
        this.verifyFailOnSingleDropFailure(this.nativeAccessor, this.fusionIndexAccessor);
    }

    @Test
    public void fusionIndexIsDirtyWhenNativeIndexIsDirty() {
        Mockito.when((Object)this.nativeAccessor.isDirty()).thenReturn((Object)true).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.fusionIndexAccessor.isDirty());
        Assert.assertFalse((boolean)this.fusionIndexAccessor.isDirty());
    }

    @Test
    public void dropMustThrowIfDropLuceneFail() throws Exception {
        this.verifyFailOnSingleDropFailure(this.luceneAccessor, this.fusionIndexAccessor);
    }

    private void verifyFailOnSingleDropFailure(IndexAccessor failingAccessor, FusionIndexAccessor fusionIndexAccessor) throws IOException {
        IOException expectedFailure = new IOException("fail");
        ((IndexAccessor)Mockito.doThrow((Throwable)expectedFailure).when((Object)failingAccessor)).drop();
        try {
            fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
    }

    @Test
    public void dropMustThrowIfBothFail() throws Exception {
        IOException nativeFailure = new IOException("native");
        IOException luceneFailure = new IOException("lucene");
        ((IndexAccessor)Mockito.doThrow((Throwable)nativeFailure).when((Object)this.nativeAccessor)).drop();
        ((IndexAccessor)Mockito.doThrow((Throwable)luceneFailure).when((Object)this.luceneAccessor)).drop();
        try {
            this.fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)AnyOf.anyOf((Matcher)Matchers.sameInstance((Object)nativeFailure), (Matcher)Matchers.sameInstance((Object)luceneFailure)));
        }
    }

    @Test
    public void closeMustCloseNativeAndLucene() throws Exception {
        this.fusionIndexAccessor.close();
        ((IndexAccessor)Mockito.verify((Object)this.nativeAccessor, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        ((IndexAccessor)Mockito.verify((Object)this.luceneAccessor, (VerificationMode)VerificationModeFactory.times((int)1))).close();
    }

    @Test
    public void closeMustThrowIfLuceneThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)this.luceneAccessor, (AutoCloseable)this.fusionIndexAccessor);
    }

    @Test
    public void closeMustThrowIfNativeThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)this.nativeAccessor, (AutoCloseable)this.fusionIndexAccessor);
    }

    @Test
    public void closeMustCloseNativeIfLuceneThrow() throws Exception {
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)this.luceneAccessor, (AutoCloseable)this.nativeAccessor, (AutoCloseable)this.fusionIndexAccessor);
    }

    @Test
    public void closeMustCloseLuceneIfNativeThrow() throws Exception {
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)this.nativeAccessor, (AutoCloseable)this.luceneAccessor, (AutoCloseable)this.fusionIndexAccessor);
    }

    @Test
    public void closeMustThrowIfBothFail() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfBothThrow((AutoCloseable)this.nativeAccessor, (AutoCloseable)this.luceneAccessor, (AutoCloseable)this.fusionIndexAccessor);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromNativeAndLucene() throws Exception {
        long[] nativeEntries = new long[]{0L, 1L, 2L, 5L, 6L};
        long[] luceneEntries = new long[]{3L, 4L, 7L, 8L};
        this.mockAllEntriesReaders(nativeEntries, luceneEntries);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        this.assertResultContainsAll(result, nativeEntries);
        this.assertResultContainsAll(result, luceneEntries);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromNativeAndLuceneWithEmptyNative() throws Exception {
        long[] nativeEntries = new long[]{};
        long[] luceneEntries = new long[]{3L, 4L, 7L, 8L};
        this.mockAllEntriesReaders(nativeEntries, luceneEntries);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        this.assertResultContainsAll(result, nativeEntries);
        this.assertResultContainsAll(result, luceneEntries);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromNativeAndLuceneWithEmptyLucene() throws Exception {
        long[] nativeEntries = new long[]{0L, 1L, 2L, 5L, 6L};
        long[] luceneEntries = new long[]{};
        this.mockAllEntriesReaders(nativeEntries, luceneEntries);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        this.assertResultContainsAll(result, nativeEntries);
        this.assertResultContainsAll(result, luceneEntries);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromNativeAndLuceneBothEmpty() throws Exception {
        long[] nativeEntries = new long[]{};
        long[] luceneEntries = new long[]{};
        this.mockAllEntriesReaders(nativeEntries, luceneEntries);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        this.assertResultContainsAll(result, nativeEntries);
        this.assertResultContainsAll(result, luceneEntries);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void allEntriesReaderMustCloseBothNativeAndLucene() throws Exception {
        BoundedIterable<Long> nativeAllEntriesReader = this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        BoundedIterable<Long> luceneAllEntriesReader = this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        this.fusionIndexAccessor.newAllEntriesReader().close();
        ((BoundedIterable)Mockito.verify(nativeAllEntriesReader, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        ((BoundedIterable)Mockito.verify(luceneAllEntriesReader, (VerificationMode)VerificationModeFactory.times((int)1))).close();
    }

    @Test
    public void allEntriesReaderMustCloseNativeIfLuceneThrow() throws Exception {
        BoundedIterable<Long> nativeAllEntriesReader = this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        BoundedIterable<Long> luceneAllEntriesReader = this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow(luceneAllEntriesReader, nativeAllEntriesReader, (AutoCloseable)fusionAllEntriesReader);
    }

    @Test
    public void allEntriesReaderMustCloseLuceneIfNativeThrow() throws Exception {
        BoundedIterable<Long> nativeAllEntriesReader = this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        BoundedIterable<Long> luceneAllEntriesReader = this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow(nativeAllEntriesReader, luceneAllEntriesReader, (AutoCloseable)fusionAllEntriesReader);
    }

    @Test
    public void allEntriesReaderMustThrowIfLuceneThrow() throws Exception {
        this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        BoundedIterable<Long> luceneAllEntriesReader = this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow(luceneAllEntriesReader, (AutoCloseable)fusionAllEntriesReader);
    }

    @Test
    public void allEntriesReaderMustThrowIfNativeThrow() throws Exception {
        BoundedIterable<Long> nativeAllEntriesReader = this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow(nativeAllEntriesReader, (AutoCloseable)fusionAllEntriesReader);
    }

    @Test
    public void allEntriesReaderMustReportUnknownMaxCountIfNativeReportUnknownMaxCount() throws Exception {
        this.mockSingleAllEntriesReaderWithUnknownMaxCount(this.nativeAccessor, new long[0]);
        this.mockSingleAllEntriesReader(this.luceneAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    public void allEntriesReaderMustReportUnknownMaxCountIfLuceneReportUnknownMaxCount() throws Exception {
        this.mockSingleAllEntriesReaderWithUnknownMaxCount(this.luceneAccessor, new long[0]);
        this.mockSingleAllEntriesReader(this.nativeAccessor, new long[0]);
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    public void allEntriesReaderMustReportFusionMaxCountOfNativeAndLucene() throws Exception {
        this.mockSingleAllEntriesReader(this.nativeAccessor, new long[]{1L, 2L});
        this.mockSingleAllEntriesReader(this.luceneAccessor, new long[]{3L, 4L});
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)4L));
    }

    private void assertResultContainsAll(Set<Long> result, long[] nativeEntries) {
        for (long nativeEntry : nativeEntries) {
            Assert.assertTrue((String)("Expected to contain " + nativeEntry + ", but was " + result), (boolean)result.contains(nativeEntry));
        }
    }

    private void mockAllEntriesReaders(long[] nativeEntries, long[] luceneEntries) {
        this.mockSingleAllEntriesReader(this.nativeAccessor, nativeEntries);
        this.mockSingleAllEntriesReader(this.luceneAccessor, luceneEntries);
    }

    private BoundedIterable<Long> mockSingleAllEntriesReader(IndexAccessor targetAccessor, long[] entries) {
        BoundedIterable<Long> allEntriesReader = this.mockedAllEntriesReader(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    private BoundedIterable<Long> mockedAllEntriesReader(long ... entries) {
        return this.mockedAllEntriesReader(true, entries);
    }

    private BoundedIterable<Long> mockSingleAllEntriesReaderWithUnknownMaxCount(IndexAccessor targetAccessor, long[] entries) {
        BoundedIterable<Long> allEntriesReader = this.mockedAllEntriesReaderUnknownMaxCount(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    private BoundedIterable<Long> mockedAllEntriesReaderUnknownMaxCount(long ... entries) {
        return this.mockedAllEntriesReader(false, entries);
    }

    private BoundedIterable<Long> mockedAllEntriesReader(boolean knownMaxCount, long ... entries) {
        BoundedIterable mockedAllEntriesReader = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)mockedAllEntriesReader.maxCount()).thenReturn((Object)(knownMaxCount ? (long)entries.length : -1L));
        Mockito.when((Object)mockedAllEntriesReader.iterator()).thenReturn((Object)Iterators.asIterator((long[])entries));
        return mockedAllEntriesReader;
    }
}

